/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.FileSignalBlock;
import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import com.egi.services.mff.api.SignalBlock;
import com.egi.services.mff.utility.LocalSignalFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class Signal
extends MFFResource {
    private static String APP_NAME = "InfoNParser";
    private static String USAGE = "File Information Parser\nUsage: InfoNParser [OPTIONS]\nwhere [OPTIONS] are:\n-r, --uri .......................... the uri where the resource is located.\n-h, -help ...................................... display this help message.\n";
    public static final String classID_ = "CAES";
    private int version_ = 0;
    private long numberOfBlocks_ = 0L;
    private ArrayList<? extends SignalBlock> signalBlocks_ = null;
    private boolean debug_ = true;

    public Signal() {
    }

    public Signal(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public Signal copy() throws CloneNotSupportedException {
        return (Signal)this.clone();
    }

    public SignalBlock loadSignalBlockData(SignalBlock signalBlock) {
        SignalBlock rVal = signalBlock;
        if (this.resourceDelegate_ instanceof LocalSignalFile) {
            LocalSignalFile localSignalFile = (LocalSignalFile)this.resourceDelegate_;
            localSignalFile.loadSignalBlockData(signalBlock);
        }
        return rVal;
    }

    public SignalBlock writeSignalBlock(SignalBlock signalBlock) {
        SignalBlock rVal = signalBlock;
        if (this.resourceDelegate_ instanceof LocalSignalFile) {
            LocalSignalFile localSignalFile = (LocalSignalFile)this.resourceDelegate_;
            localSignalFile.writeSignalBlockData(signalBlock);
        }
        return rVal;
    }

    public int getVersion() {
        return this.version_;
    }

    public void setVersion(int version) {
        this.version_ = version;
    }

    public long getNumberOfBlocks() {
        return this.numberOfBlocks_;
    }

    public void setNumberOfBlocks(long numberOfBlocks) {
        this.numberOfBlocks_ = numberOfBlocks;
    }

    public ArrayList<? extends SignalBlock> getSignalBlocks() {
        return this.signalBlocks_;
    }

    public void setSignalBlocks(ArrayList<? extends SignalBlock> signalBlocks) {
        this.signalBlocks_ = signalBlocks;
    }

    public String getClassID() {
        return classID_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
        if (this.resourceDelegate_ instanceof LocalSignalFile) {
            ((LocalSignalFile)this.resourceDelegate_).setDebug(debug);
        }
    }

    public boolean getDubug() {
        return this.debug_;
    }

    public static void test(String uri) {
        try {
            System.out.println("\nSignal: this example prints the resource map, and attempts to load \nthe 4th signal block from the resource.\n");
            System.out.println("Signal: Task will begin in 5 seconds ...\n\n");
            Thread.sleep(4000L);
            System.out.println("Signal: reading file: " + uri);
            long beginTime = System.currentTimeMillis();
            long endTime = 0L;
            MFFFactory factory = new MFFFactory(new LocalMFFFactoryDelegate());
            MFFResourceType resourceType = new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_Signal);
            MFFResource resource = factory.openResourceAtURI(uri, resourceType);
            if (resource instanceof Signal) {
                Signal signal = (Signal)resource;
                if (signal.loadResource()) {
                    long numberOfBlocks = signal.getNumberOfBlocks();
                    System.out.println("");
                    System.out.println("Signal: number of signal blocks: " + numberOfBlocks);
                    System.out.println("");
                    ArrayList<? extends SignalBlock> signalBlocks = signal.getSignalBlocks();
                    for (SignalBlock signalBlock : signalBlocks) {
                        if (!(signalBlock instanceof FileSignalBlock)) continue;
                        FileSignalBlock fileSignalBlock = (FileSignalBlock)signalBlock;
                        System.out.println("Signal: block:");
                        System.out.println("Signal: header location: " + fileSignalBlock.fileOffsetForHeader);
                        System.out.println("Signal: data location: " + fileSignalBlock.fileOffsetForData);
                        if (fileSignalBlock.version != 0) {
                            System.out.println("Signal: Version: " + signalBlock.version);
                            System.out.println("Signal: Header size: " + signalBlock.headerSize);
                            System.out.println("Signal: Data block size: " + signalBlock.dataBlockSize);
                            System.out.println("Signal: Number of signals: " + signalBlock.numberOfSignals);
                            System.out.println("Signal: Optional header size: " + signalBlock.optionalHeaderSize);
                            if (signalBlock.signalFrequency != null && signalBlock.signalFrequency.length > 0) {
                                System.out.println("Signal: Sampling rate: " + signalBlock.signalFrequency[0]);
                            }
                        }
                        System.out.println("");
                    }
                    endTime = System.currentTimeMillis();
                    long mappingTime = endTime - beginTime;
                    System.out.println("Signal: trying to load the 4th block (if it exists) ...");
                    beginTime = System.currentTimeMillis();
                    if (numberOfBlocks >= 4L) {
                        System.out.println("Signal: 4th signal block exists, loading ...");
                        SignalBlock signalBlock = signal.loadSignalBlockData(signalBlocks.get(3));
                        System.out.println("Signal: done loading 4th signal, checking ...");
                        if (signalBlock.data instanceof byte[]) {
                            byte[] signalBlockData = (byte[])signalBlock.data;
                            if (signalBlockData.length == signalBlock.dataBlockSize) {
                                System.out.println("Signal: successfully loaded " + signalBlockData.length + " bytes of signal block data");
                            } else {
                                System.out.println("Signal: error: unexpected signal block size: got: " + signalBlockData.length + " expected: " + signalBlock.dataBlockSize);
                            }
                            signalBlock.data = null;
                        } else {
                            System.out.println("Signal: unknown error: unable to load signal block data");
                        }
                    } else {
                        System.out.println("Signal: error: 4th signal block does not exist, skipping load.");
                    }
                    endTime = System.currentTimeMillis();
                    long blockLoadingTime = endTime - beginTime;
                    System.out.println("\n");
                    System.out.println("Signal: time taken to map file (including outputs): " + mappingTime + " milliseconds");
                    System.out.println("Signal: time taken load block  (including outputs): " + blockLoadingTime + " milliseconds");
                    String newResourceURI = uri + "_new";
                    System.out.println("Signal: Saving blocks to new signal resource uri: " + newResourceURI);
                    if (factory.resourceExistsAtURI(newResourceURI, resourceType)) {
                        factory.deleteResourceAtURI(newResourceURI, resourceType);
                    }
                    factory.createResourceAtURI(newResourceURI, resourceType);
                    MFFResource newResource = factory.openResourceAtURI(newResourceURI, resourceType);
                    if (newResource instanceof Signal) {
                        Signal newSignalResource = (Signal)newResource;
                        newSignalResource.setDebug(true);
                        int blockLoadCount = 0;
                        for (SignalBlock signalBlock : signalBlocks) {
                            System.out.println("Signal: loading block: " + blockLoadCount);
                            SignalBlock signalBlock2 = signal.loadSignalBlockData(signalBlock);
                            System.out.println("Signal: saving block: " + blockLoadCount);
                            newSignalResource.writeSignalBlock(signalBlock2);
                            signalBlock2.data = null;
                            ++blockLoadCount;
                        }
                        factory.closeResource(newResource);
                    } else {
                        System.out.println("Signal: error: unable to open resource: " + newResourceURI);
                    }
                    System.out.println("Signal: Done saving blocks to new signal resource");
                }
                factory.closeResource(resource);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            OptionParser parser = new OptionParser("r:h");
            parser.accepts("help");
            parser.accepts("uri").withRequiredArg();
            OptionSet optionSet = parser.parse(args);
            if (optionSet.has("h") || optionSet.has("help")) {
                System.out.println(APP_NAME + ": " + USAGE);
                System.exit(0);
            }
            String uri = null;
            if (optionSet.has("r") || optionSet.hasArgument("r")) {
                uri = (String)optionSet.valueOf("r");
            } else if (optionSet.has("uri") || optionSet.hasArgument("uri")) {
                uri = (String)optionSet.valueOf("uri");
            } else {
                System.err.println(APP_NAME + ": error: " + USAGE);
                System.exit(-1);
            }
            System.out.println("\nSignal: this example prints the resource map, and attempts to load \nthe 4th signal block from the resource.\n");
            System.out.println("Signal: Task will begin in 5 seconds ...\n\n");
            Thread.sleep(4000L);
            System.out.println("Signal: reading file: " + uri);
            long beginTime = System.currentTimeMillis();
            long endTime = 0L;
            MFFFactory factory = new MFFFactory(new LocalMFFFactoryDelegate());
            MFFResourceType resourceType = new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_Signal);
            MFFResource resource = factory.openResourceAtURI(uri, resourceType);
            if (resource instanceof Signal) {
                Signal signal = (Signal)resource;
                if (signal.loadResource()) {
                    long numberOfBlocks = signal.getNumberOfBlocks();
                    System.out.println("");
                    System.out.println("Signal: number of signal blocks: " + numberOfBlocks);
                    System.out.println("");
                    ArrayList<? extends SignalBlock> signalBlocks = signal.getSignalBlocks();
                    for (SignalBlock signalBlock : signalBlocks) {
                        if (!(signalBlock instanceof FileSignalBlock)) continue;
                        FileSignalBlock fileSignalBlock = (FileSignalBlock)signalBlock;
                        System.out.println("Signal: block:");
                        System.out.println("Signal: header location: " + fileSignalBlock.fileOffsetForHeader);
                        System.out.println("Signal: data location: " + fileSignalBlock.fileOffsetForData);
                        if (fileSignalBlock.version != 0) {
                            System.out.println("Signal: Version: " + signalBlock.version);
                            System.out.println("Signal: Header size: " + signalBlock.headerSize);
                            System.out.println("Signal: Data block size: " + signalBlock.dataBlockSize);
                            System.out.println("Signal: Number of signals: " + signalBlock.numberOfSignals);
                            System.out.println("Signal: Optional header size: " + signalBlock.optionalHeaderSize);
                            if (signalBlock.signalFrequency != null && signalBlock.signalFrequency.length > 0) {
                                System.out.println("Signal: Sampling rate: " + signalBlock.signalFrequency[0]);
                            }
                        }
                        System.out.println("");
                    }
                    endTime = System.currentTimeMillis();
                    long mappingTime = endTime - beginTime;
                    System.out.println("Signal: trying to load the 4th block (if it exists) ...");
                    beginTime = System.currentTimeMillis();
                    if (numberOfBlocks >= 4L) {
                        System.out.println("Signal: 4th signal block exists, loading ...");
                        SignalBlock signalBlock = signal.loadSignalBlockData(signalBlocks.get(3));
                        System.out.println("Signal: done loading 4th signal, checking ...");
                        if (signalBlock.data instanceof byte[]) {
                            byte[] signalBlockData = (byte[])signalBlock.data;
                            if (signalBlockData.length == signalBlock.dataBlockSize) {
                                System.out.println("Signal: successfully loaded " + signalBlockData.length + " bytes of signal block data");
                            } else {
                                System.out.println("Signal: error: unexpected signal block size: got: " + signalBlockData.length + " expected: " + signalBlock.dataBlockSize);
                            }
                            signalBlock.data = null;
                        } else {
                            System.out.println("Signal: unknown error: unable to load signal block data");
                        }
                    } else {
                        System.out.println("Signal: error: 4th signal block does not exist, skipping load.");
                    }
                    endTime = System.currentTimeMillis();
                    long blockLoadingTime = endTime - beginTime;
                    System.out.println("\n");
                    System.out.println("Signal: time taken to map file (including outputs): " + mappingTime + " milliseconds");
                    System.out.println("Signal: time taken load block  (including outputs): " + blockLoadingTime + " milliseconds");
                    String newResourceURI = uri + "_new";
                    System.out.println("Signal: Saving blocks to new signal resource uri: " + newResourceURI);
                    if (factory.resourceExistsAtURI(newResourceURI, resourceType)) {
                        factory.deleteResourceAtURI(newResourceURI, resourceType);
                    }
                    factory.createResourceAtURI(newResourceURI, resourceType);
                    MFFResource newResource = factory.openResourceAtURI(newResourceURI, resourceType);
                    if (newResource instanceof Signal) {
                        Signal newSignalResource = (Signal)newResource;
                        newSignalResource.setDebug(true);
                        int blockLoadCount = 0;
                        for (SignalBlock signalBlock : signalBlocks) {
                            System.out.println("Signal: loading block: " + blockLoadCount);
                            SignalBlock signalBlock2 = signal.loadSignalBlockData(signalBlock);
                            System.out.println("Signal: saving block: " + blockLoadCount);
                            newSignalResource.writeSignalBlock(signalBlock2);
                            signalBlock2.data = null;
                            ++blockLoadCount;
                        }
                        factory.closeResource(newResource);
                    } else {
                        System.out.println("Signal: error: unable to open resource: " + newResourceURI);
                    }
                    System.out.println("Signal: Done saving blocks to new signal resource");
                }
                factory.closeResource(resource);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

