/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.Categories;
import com.egi.services.mff.api.Coordinates;
import com.egi.services.mff.api.Epochs;
import com.egi.services.mff.api.EventTrack;
import com.egi.services.mff.api.History;
import com.egi.services.mff.api.Info;
import com.egi.services.mff.api.InfoN;
import com.egi.services.mff.api.MFFFile;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import com.egi.services.mff.api.PNSSet;
import com.egi.services.mff.api.SensorLayout;
import com.egi.services.mff.api.Signal;
import com.egi.services.mff.api.Subject;
import com.egi.services.mff.interfaces.MFFFactoryDelegate;
import com.egi.services.mff.utility.LocalSignalFile;
import com.egi.services.mff.utility.XMLLocalFileResource;
import com.egi.services.mff.utility.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalMFFFactoryDelegate
implements MFFFactoryDelegate {
    @Override
    public boolean resourceExistsAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && resourceType != null) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case 1: 
                case 13: {
                    rVal = file.isDirectory();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: {
                    rVal = file.isFile();
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean createResourceAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && resourceType != null) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case 1: 
                case 13: {
                    try {
                        File contentsFile;
                        rVal = file.mkdir();
                        if (!rVal || !(rVal = (contentsFile = new File(file, "Contents")).mkdir())) break;
                        File pkgInfoFile = new File(contentsFile, "PkgInfo");
                        FileUtils.writeStringToFile(pkgInfoFile, "MFFrNETs");
                        File infoPlist = new File(contentsFile, "Info.plist");
                        Document document = XMLUtil.newXMLDocument();
                        document.setXmlStandalone(true);
                        Element root = document.createElement("plist");
                        root.setAttribute("version", "1.0");
                        Element dictNode = document.createElement("dict");
                        XMLUtil.appendChild(dictNode, "key", "CFBundleName", false, document);
                        switch (resourceType.getResourceType()) {
                            case 13: {
                                XMLUtil.appendChild(dictNode, "string", "Net Station Photogrammetry Recording", false, document);
                                break;
                            }
                            default: {
                                XMLUtil.appendChild(dictNode, "string", "Net Station MFF Recording", false, document);
                            }
                        }
                        XMLUtil.appendChild(dictNode, "key", "CFBundlePackageType", false, document);
                        XMLUtil.appendChild(dictNode, "string", "MFFr", false, document);
                        XMLUtil.appendChild(dictNode, "key", "CFBundleSignature", false, document);
                        XMLUtil.appendChild(dictNode, "string", "NETs", false, document);
                        root.appendChild(dictNode);
                        document.appendChild(root);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        transformer.setOutputProperty("standalone", "yes");
                        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("doctype-public", "-//Apple Computer//DTD PLIST 1.0//EN");
                        transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
                        XMLUtil.transformDOMtoURI(infoPlist.getPath(), null, document, transformer, false);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                        rVal = false;
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: {
                    try {
                        rVal = file.createNewFile();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean deleteResourceAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && this.resourceExistsAtURI(uri, resourceType)) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case 1: 
                case 13: {
                    rVal = file.delete();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: {
                    rVal = file.delete();
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean moveResourceAtURI(String sourceURI, String destinationURI, MFFResourceType resourceType) {
        boolean rVal = false;
        if (sourceURI != null && destinationURI != null && this.resourceExistsAtURI(sourceURI, resourceType)) {
            File sourceFile = new File(sourceURI);
            File destinationFile = new File(destinationURI);
            try {
                switch (resourceType.getResourceType()) {
                    case 1: 
                    case 13: {
                        FileUtils.moveDirectoryToDirectory(sourceFile, destinationFile, true);
                        rVal = true;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 14: {
                        FileUtils.moveFileToDirectory(sourceFile, destinationFile, true);
                        rVal = true;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                rVal = false;
            }
        }
        return rVal;
    }

    @Override
    public boolean copyResourceAtURI(String sourceURI, String destinationURI, MFFResourceType resourceType) {
        boolean rVal = false;
        if (sourceURI != null && destinationURI != null && this.resourceExistsAtURI(sourceURI, resourceType)) {
            File sourceFile = new File(sourceURI);
            File destinationFile = new File(destinationURI);
            try {
                switch (resourceType.getResourceType()) {
                    case 1: 
                    case 13: {
                        FileUtils.copyDirectory(sourceFile, destinationFile);
                        rVal = true;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 14: {
                        FileUtils.copyFile(sourceFile, destinationFile);
                        rVal = true;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                rVal = false;
            }
        }
        return rVal;
    }

    @Override
    public MFFResource openResourceAtURI(String uri, MFFResourceType resourceType) {
        MFFResource rVal = null;
        if (uri != null && this.resourceExistsAtURI(uri, resourceType)) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case 1: {
                    rVal = new MFFFile(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 2: {
                    rVal = new Signal(uri, new LocalSignalFile(uri), resourceType);
                    break;
                }
                case 13: {
                    break;
                }
                case 3: {
                    rVal = new EventTrack(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 4: {
                    rVal = new Epochs(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 5: {
                    rVal = new Subject(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 6: {
                    rVal = new History(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 7: {
                    rVal = new Info(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 8: {
                    rVal = new InfoN(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 9: {
                    rVal = new Categories(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 11: {
                    rVal = new SensorLayout(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 12: {
                    rVal = new Coordinates(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case 14: {
                    rVal = new PNSSet(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean closeResource(MFFResource resource) {
        boolean rVal = false;
        return rVal;
    }
}

