function key = parsekeyboardevent(eventdata)

% PARSEKEYBOARDEVENT handles keyboard events for Windows, Mac OSX and Linux systems.
%
% shift+numpad number does not work on UNIX, since the shift modifier is always sent for numpad events

key = eventdata.Key;
if isunix()
  shiftInd = match_str(eventdata.Modifier, 'shift');
  if ~isnan(str2double(eventdata.Character)) && ~isempty(shiftInd)
    % now we now it was a numpad keystroke (numeric character sent AND
    % shift modifier present)
    key = eventdata.Character;
    eventdata.Modifier(shiftInd) = []; % strip the shift modifier
  end
elseif ispc()
  if strfind(eventdata.Key, 'numpad')
    key = eventdata.Character;d
  end
end

if ~isempty(eventdata.Modifier)
  key = [eventdata.Modifier{1} '+' key];
end
