/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import com.egi.services.mff.api.FileSignalBlock;
import com.egi.services.mff.api.Signal;
import com.egi.services.mff.api.SignalBlock;
import com.egi.services.mff.interfaces.MarshallingProtocol;
import com.egi.services.mff.utility.ResourceMarshalException;
import com.egi.services.mff.utility.ResourceUnmarshalException;
import com.egi.services.mff.utility.SignalUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalSignalFile
implements MarshallingProtocol {
    private File file_ = null;
    private FileSignalBlock savedFileSignalBlock_ = null;
    private boolean debug_ = false;

    public LocalSignalFile(String uri) {
        this.file_ = new File(uri);
    }

    @Override
    public Object marshal(Object fromObject, String uri) throws ResourceMarshalException {
        Object rVal = fromObject;
        this.debugMessage("marshalling signal resource...");
        if (fromObject instanceof Signal) {
            Signal signalResource = (Signal)fromObject;
            ArrayList<? extends SignalBlock> signalBlocks = signalResource.getSignalBlocks();
            for (SignalBlock signalBlock : signalBlocks) {
                this.debugMessage("saving signal block...");
                this.writeSignalBlockData(signalBlock);
                this.debugMessage("done saving signal block");
            }
        } else {
            throw new ResourceMarshalException("LocalSignalFile: could not validate source object");
        }
        this.debugMessage("done marshalling signal resource");
        return rVal;
    }

    @Override
    public Object unmarshal(Object toObject, String uri) throws ResourceUnmarshalException {
        Object rVal = toObject;
        if (toObject instanceof Signal) {
            Signal signalResource = (Signal)toObject;
            ArrayList<? extends SignalBlock> signalBlocks = this.loadSignalBlocks(false);
            if (signalBlocks != null) {
                int version = 0;
                int numberOfBlocks = signalBlocks.size();
                if (numberOfBlocks > 0) {
                    version = signalBlocks.get((int)0).version;
                }
                signalResource.setSignalBlocks(signalBlocks);
                signalResource.setVersion(version);
                signalResource.setNumberOfBlocks(numberOfBlocks);
            }
        } else {
            throw new ResourceUnmarshalException("LocalSignalFile: could not validate destination object");
        }
        return rVal;
    }

    public ArrayList<? extends SignalBlock> loadSignalBlocks(boolean loadDataBlock) {
        ArrayList<FileSignalBlock> signalBlocks = new ArrayList<FileSignalBlock>();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_, "rw");
            randomAccessFile.seek(0L);
            FileSignalBlock fileSignalBlock = this.signalBlock(randomAccessFile, false);
            if (fileSignalBlock != null) {
                int currentDataBlockSize = fileSignalBlock.dataBlockSize;
                while (fileSignalBlock != null) {
                    signalBlocks.add(fileSignalBlock);
                    if (fileSignalBlock.version == 0) {
                        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)currentDataBlockSize);
                    } else {
                        currentDataBlockSize = fileSignalBlock.dataBlockSize;
                        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)currentDataBlockSize);
                    }
                    fileSignalBlock = this.signalBlock(randomAccessFile, false);
                }
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return signalBlocks;
    }

    public SignalBlock loadSignalBlockData(SignalBlock signalBlock) {
        SignalBlock rVal = signalBlock;
        FileSignalBlock fileSignalBlock = null;
        if (signalBlock instanceof FileSignalBlock) {
            fileSignalBlock = (FileSignalBlock)rVal;
            try {
                if (fileSignalBlock.fileOffsetForData != -1L) {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_, "rw");
                    randomAccessFile.seek(fileSignalBlock.fileOffsetForData);
                    fileSignalBlock.data = new byte[fileSignalBlock.dataBlockSize];
                    randomAccessFile.read((byte[])fileSignalBlock.data);
                    randomAccessFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rVal;
    }

    public SignalBlock writeSignalBlockData(SignalBlock signalBlock) {
        SignalBlock rVal;
        block13: {
            rVal = signalBlock;
            if (signalBlock != null) {
                try {
                    int i;
                    if (signalBlock.version == 0) {
                        this.debugMessage("writing continuation block...");
                        if (signalBlock.data instanceof byte[]) {
                            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_, "rw");
                            randomAccessFile.seek(randomAccessFile.length());
                            randomAccessFile.writeInt(0);
                            randomAccessFile.write((byte[])signalBlock.data);
                            randomAccessFile.close();
                        } else {
                            System.out.println("LocalSignalFile: error: unexpect type when tring to write continuation block");
                        }
                        this.debugMessage("done writing a continuation block");
                        break block13;
                    }
                    this.debugMessage("writing non-continuation block...");
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.file_, "rw");
                    randomAccessFile.seek(randomAccessFile.length());
                    this.debugMessage("header size: " + signalBlock.headerSize);
                    this.debugMessage("data block size: " + signalBlock.dataBlockSize);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(signalBlock.headerSize + signalBlock.dataBlockSize);
                    byteBuffer.putInt(Integer.reverseBytes(signalBlock.version));
                    byteBuffer.putInt(Integer.reverseBytes(signalBlock.headerSize));
                    byteBuffer.putInt(Integer.reverseBytes(signalBlock.dataBlockSize));
                    byteBuffer.putInt(Integer.reverseBytes(signalBlock.numberOfSignals));
                    for (i = 0; i < signalBlock.numberOfSignals; ++i) {
                        byteBuffer.putInt(Integer.reverseBytes(signalBlock.offsets[i]));
                    }
                    for (i = 0; i < signalBlock.numberOfSignals; ++i) {
                        byte[] signalInfoBytes = SignalUtil.packSignalInfo(signalBlock.signalDepth[i], signalBlock.signalFrequency[i]);
                        byteBuffer.put(signalInfoBytes);
                    }
                    byteBuffer.putInt(Integer.reverseBytes(signalBlock.optionalHeaderSize));
                    if (signalBlock.optionalHeader instanceof byte[]) {
                        byteBuffer.put((byte[])signalBlock.optionalHeader);
                    }
                    if (signalBlock.data instanceof byte[]) {
                        byteBuffer.put((byte[])signalBlock.data);
                    }
                    if (byteBuffer.position() == byteBuffer.capacity()) {
                        randomAccessFile.write(byteBuffer.array());
                    } else {
                        System.out.println("LocalSignalFile: error: invalid block size: expected: " + byteBuffer.capacity() + " got: " + byteBuffer.position());
                    }
                    randomAccessFile.close();
                    this.debugMessage("done writing non-continuation block");
                }
                catch (IOException ex) {
                    Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                System.out.println("LocalSignalFile: error: null signal block");
            }
        }
        return rVal;
    }

    private FileSignalBlock signalBlock(RandomAccessFile file, boolean loadDataBlock) {
        FileSignalBlock rVal = null;
        if (file != null) {
            try {
                long headerLocationInFile = file.getFilePointer();
                FileSignalBlock fileSignalBlock = new FileSignalBlock();
                fileSignalBlock.version = Integer.reverseBytes(file.readInt());
                if (fileSignalBlock.version != 0) {
                    fileSignalBlock.headerSize = Integer.reverseBytes(file.readInt());
                    fileSignalBlock.dataBlockSize = Integer.reverseBytes(file.readInt());
                    fileSignalBlock.numberOfSignals = Integer.reverseBytes(file.readInt());
                    fileSignalBlock.offsets = new int[fileSignalBlock.numberOfSignals];
                    for (int i = 0; i < fileSignalBlock.numberOfSignals; ++i) {
                        fileSignalBlock.offsets[i] = Integer.reverseBytes(file.readInt());
                    }
                    fileSignalBlock.signalDepth = new int[fileSignalBlock.numberOfSignals];
                    fileSignalBlock.signalFrequency = new int[fileSignalBlock.numberOfSignals];
                    byte[] signalInfoBytes = new byte[4];
                    for (int i = 0; i < fileSignalBlock.numberOfSignals; ++i) {
                        if (file.read(signalInfoBytes) != 4) continue;
                        int[] signalInfo = SignalUtil.unpackSignalInfo(signalInfoBytes);
                        if (signalInfo != null && signalInfo.length == 2) {
                            fileSignalBlock.signalDepth[i] = signalInfo[0];
                            fileSignalBlock.signalFrequency[i] = signalInfo[1];
                            continue;
                        }
                        fileSignalBlock.signalDepth[i] = -1;
                        fileSignalBlock.signalFrequency[i] = -1;
                    }
                    fileSignalBlock.optionalHeaderSize = Integer.reverseBytes(file.readInt());
                    if (fileSignalBlock.optionalHeaderSize <= 1024) {
                        fileSignalBlock.optionalHeader = new byte[fileSignalBlock.optionalHeaderSize];
                        file.read((byte[])fileSignalBlock.optionalHeader);
                    } else {
                        System.out.println("LocalSignalFile: error: bad optional header length: " + fileSignalBlock.optionalHeaderSize);
                    }
                    this.savedFileSignalBlock_ = fileSignalBlock;
                } else if (this.savedFileSignalBlock_ != null) {
                    fileSignalBlock.headerSize = this.savedFileSignalBlock_.headerSize;
                    fileSignalBlock.dataBlockSize = this.savedFileSignalBlock_.dataBlockSize;
                    fileSignalBlock.numberOfSignals = this.savedFileSignalBlock_.numberOfSignals;
                    fileSignalBlock.offsets = (int[])this.savedFileSignalBlock_.offsets.clone();
                    fileSignalBlock.signalDepth = (int[])this.savedFileSignalBlock_.signalDepth.clone();
                    fileSignalBlock.signalFrequency = (int[])this.savedFileSignalBlock_.signalFrequency.clone();
                    fileSignalBlock.optionalHeaderSize = this.savedFileSignalBlock_.optionalHeaderSize;
                    if (this.savedFileSignalBlock_.optionalHeader instanceof byte[]) {
                        fileSignalBlock.optionalHeader = ((byte[])this.savedFileSignalBlock_.optionalHeader).clone();
                    }
                }
                rVal = fileSignalBlock;
                rVal.fileOffsetForHeader = headerLocationInFile;
                rVal.fileOffsetForData = file.getFilePointer();
            }
            catch (EOFException ex) {
            }
            catch (IOException ex) {
                Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rVal;
    }

    public void printSignalBlockSummary(FileSignalBlock signalBlock) {
        if (signalBlock != null) {
            System.out.println("LocalSignalFile: Version: " + signalBlock.version);
            System.out.println("LocalSignalFile: Header size: " + signalBlock.headerSize);
            System.out.println("LocalSignalFile: Data block size: " + signalBlock.dataBlockSize);
            System.out.println("LocalSignalFile: Number of signals: " + signalBlock.numberOfSignals);
            System.out.println("LocalSignalFile: Optional header size: " + signalBlock.optionalHeaderSize);
        }
    }

    public void debugMessage(String debugMessage) {
        if (this.debug_) {
            System.out.println("LocalSignalFile: " + debugMessage);
        }
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean getDubug() {
        return this.debug_;
    }

    public static void main(String[] args) {
        try {
            System.out.println("LocalSignalFile: reading file: file:///Users/bertie/Desktop/79 0513 1147/signal1.bin");
            LocalSignalFile signalFileReader = new LocalSignalFile("/Users/bertie/Desktop/79 0513 1147/signal1.bin");
            ArrayList<? extends SignalBlock> fileSignalBlocks = signalFileReader.loadSignalBlocks(false);
            int numberOfBlocks = fileSignalBlocks.size();
            System.out.println("");
            System.out.println("LocalSignalFile: number of signal blocks: " + numberOfBlocks);
            System.out.println("");
            for (SignalBlock signalBlock : fileSignalBlocks) {
                if (signalBlock == null || !(signalBlock instanceof FileSignalBlock)) continue;
                FileSignalBlock fileSignalBlock = (FileSignalBlock)signalBlock;
                System.out.println("LocalSignalFile: block:");
                System.out.println("LocalSignalFile: header location: " + fileSignalBlock.fileOffsetForHeader);
                System.out.println("LocalSignalFile: data location: " + fileSignalBlock.fileOffsetForData);
                if (fileSignalBlock.version != 0) {
                    signalFileReader.printSignalBlockSummary(fileSignalBlock);
                }
                System.out.println("");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LocalSignalFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

