function sqddemo(action)
% SQDDEMO; Provides a interactive demo explaining the use of sqdread and
% sqdwrite functions
persistent Newline;
persistent Running;
persistent Decoration;
if ~nargin
    action = 'start';
end;

switch lower(action)
    case 'init'
        Newline = sprintf('\n');
        Running = uicontinue('Starting Demo -->');
        Decoration(1:80) = '-';
        Decoration = [Decoration, Newline];
    case 'start'
        sqddemo('init');
        if Running
            clc;
            txt = ['Hello', Newline,...
                    'Welcome to this SQD-demonstration',Newline,...
                    'This demo hopes to explain the use of matlab functions',Newline,...
                    'SQDREAD and SQDWRITE which will let you interface ',Newline,...
                    'MATLAB data structures with MEG160 sqd-files.',Newline,Newline,...
                    Decoration,Newline...
                    'If you have any questions/suggestions, please email to:',Newline,...
                    '   shantanu@isr.umd.edu - Shantanu Ray',Newline,Decoration,Newline];
            disp(txt);
        end;
        
        Running = uicontinue('Next - Sqdread -->');
        sqddemo('read');
        
        Running = uicontinue('Next - Sqdwrite -->');
        sqddemo('write');
        disp(['End of the demo',Newline,Decoration]);
        
    case 'read'
        
        if Running
            clc;
            txt = ['Lets begin with SQDREAD',Newline,Decoration,Newline,...
                    'Usage :',Newline,Newline,...
                    'DATA = sqdread(FILENAME,''CHANNELS'',[C1 C2 C3,...],...',Newline,...
                    '            ''SAMPLES'',[S1 SN],''FORMAT'',''double'');',Newline,...
                    Newline,...
                    'SQDREAD opens the sqd-file FILENAME, reads the data for Channels ',Newline,...
                    '[C1,C2,C3,...], Samples from S1 to SN and returns to you a matrix',Newline,...
                    'DATA. The format of DATA is as follows :',Newline,...
                    'DATA = [Chan(0)Sample(1),  Chan(1)Sample(1),   ... Chan(end-1)Sample(1) ;...',Newline,... 
                    '        Chan(0)Sample(2),  Chan(1)Sample(2),   ...         .            ;...',Newline,...
                    '              .                    .                       .            ;...',Newline,...
                    '              .                    .                       .            ;...',Newline,...
                    '        Chan(0)Sample(end), Chan(1)Sample(end),... Chan(end-1)Sample(end)]',Newline,Newline,...
                    'SQDREAD can also return the information (INFO) regarding the Data Acquisition',Newline,...
                    'as a MATLAB object belonging to the class SQDHANDLE',Newline,...
                    'To return only the INFO: ',Newline,...
                    '   INFO = sqdread(FILENAME,''Info'');',Newline,Newline,...
                    'For a quick intro into SQDHANDLE, try sqddemo(''sqdhandle'') or help sqdhandle.',Newline,Decoration,Newline ];
            disp(txt);
            Running = uicontinue('Next - Other ways of using sqdread -->');
            sqddemo('read1');
        end;
        
    case 'read1'
        if Running
            clc;
            txt = ['Other ways of using SQDREAD are as follows: ',Newline,Decoration,Newline,...                    
                    'In the call for getting data, specification of channels, samples,',Newline,...
                    'format is completely optional. Hence,...',Newline,...
                    '   DATA = sqdread(FILENAME);   Returns all the data in the file',Newline,...
                    '   DATA = sqdread(FILENAME,''Channels'',[0:9]);  Returns all the data',Newline,...
                    '       for channels from 0 to 9.',Newline,...
                    '   DATA = sqdread(FILENAME,''Samples'',[1001 2000]); Returns data for',Newline,...
                    '       for all channels but samples 1001 to 2000',Newline,Newline,...
                    'SQDREAD can be used to return DATA and INFO simultaneously',Newline,...
                    'ie. all of the above commands could have been called as follows:',Newline,...
                    '   [DATA,INFO] = sqdread(FILENAME,...);',Newline,Decoration,Newline];
            disp(txt);
        end;
        
    case 'write'
        if Running,
            clc;
            txt = ['Before we continue on to SQDWRITE,',Newline,...
                    'let us briefly look at the structure of the',Newline,...
                    'sqd-files.',Newline,Decoration,Newline,...
                    'The sqd-files generated from MEG160 contain not',Newline,...
                    'only the data collected but also information',Newline,...
                    'regarding the condition under which the',Newline,...
                    'experiment was conducted.',Newline,Newline,...
                    'Unfortunately, only part of the details of',Newline,...
                    'the way in which information is written to',Newline,...
                    'the sqd-files is known.',Newline,Newline,...
                    'Hence in order for MEG160 to open any ',Newline,...
                    'file that we create, we must insert',Newline,...
                    'information regarding data acquisition',Newline,...
                    'from an already existing sqd-file. Hence,',Newline,...
                    'an assumption is made that the user starts',Newline,...
                    'with a sqd-file from MEG160, reads the data',Newline,...
                    'using SQDREAD, and then having processed',Newline,...
                    'the data, uses SQDWRITE to write to a new',Newline,...
                    'file. The original sqd-file will be used as',Newline,...
                    'a template for the new file. SQDWRITE can',Newline,...
                    'also be used to directly modify the original',Newline,...
                    'sqd-file.',Newline,Decoration,Newline];   
            disp(txt);
            Running = uicontinue('Next - Using sqdwrite to create a new file -->');
            sqddemo('write1');
            Running = uicontinue('Next - sqdwrite in APPEND mode -->');
            sqddemo('write2');
            Running = uicontinue('Next - sqdwrite in OVERWRITE mode -->');
            sqddemo('write3');
        end;
        
    case 'write1'
        if Running,
            clc;
            txt = ['Now on to SQDWRITE: ',Newline,Decoration,Newline,...
                    'Usage:',Newline,Newline,...
                    '1. To create a new sqd-file:',Newline,Decoration,Newline,...
                    '[ERR,INFO] = sqdwrite(SOURCE,...',Newline,...
                    '                     DESTINATION,...',Newline,...
                    '                     DATA);',Newline,Newline,...
                    '   where,',Newline,...
                    '       SOURCE - Source sqd-file name (for template)',Newline,...
                    '       DESTINATION - Destination sqd-file name',Newline,...
                    '       DATA - The data to be written the destination',Newline,...
                    '           file. Data should be arranged in matrix',Newline,...
                    '           in the same format as the output of SQDREAD',Newline,...
                    '           i.e. DATA = ',Newline,...
                    '           [Chan(0)Sample(1),  Chan(1)Sample(1),   ... Chan(end-1)Sample(1) ;...',Newline,... 
                    '            Chan(0)Sample(2),  Chan(1)Sample(2),   ...         .            ;...',Newline,...
                    '                  .                    .                       .            ;...',Newline,...
                    '                  .                    .                       .            ;...',Newline,...
                    '           Chan(0)Sample(end), Chan(1)Sample(end), ... Chan(end-1)Sample(end)]',Newline,...
                    '           SQDWRITE gets information about number of samples',Newline,...
                    '           from the size of DATA. Number of channels in the',Newline,...
                    '           DATA should be equal to the Source sqd-file.',Newline,...
                    '       ERR - Error/Confirmation count. If SQDWRITE',Newline,...
                    '           is successful, ERR = number of bytes written',Newline,...
                    '           to new file. If SQDWRITE is unsuccessful',Newline,...
                    '           ERR = -1.',Newline,...
                    '       INFO - SQDHANDLE to the new sqd-file',Newline,Decoration,Newline];
            disp(txt);
        end;
        
    case 'write2'
        if Running,
            clc,
            txt = ['2. To append data:',Newline,Decoration,Newline,...
                    '[ERR,INFO] = sqdwrite(SOURCE,DESTINATION,...',Newline,...
                    '                      ''ACTION'',''APPEND'',...',Newline,...
                    '                      ''DATA'',APPEND-DATA);',Newline,Newline,...
                    'In APPEND mode, SQDWRITE assumes that APPEND-DATA',Newline,...
                    'has data for all channels of the SOURCE FILE and ',Newline,...
                    'merely appens to already existing data',Newline,...
                    'SOURCE and DESTINTION can be the same.',Newline,...
                    'ERR will return the number of bytes successfully',Newline,...
                    'appended, whereas, INFO will have an updated',Newline,...
                    'number of Samples',Newline,Decoration,Newline];
            disp(txt);
        end;
        
    case 'write3'
        if Running,
            clc
            txt = ['3. To overwrite data:',Newline,Decoration,Newline,...
                    '[ERR,INFO] = sqdwrite(SOURCE,DESTINATION,...',Newline,...
                    '                      ''ACTION'',''OVERWRITE'',...',Newline,...
                    '                      ''CHANNELS'',[CH1 CH2 .. CHn],...',Newline,...
                    '                      ''SAMPLES'',[SAMP1 SAMPN],...',Newline,...
 	                '                      ''DATA'',OVERWRITE-DATA);',Newline,Newline,...
                    '   where,',Newline,...
                    '      CHANNELS - Channel number which should be overwritten',Newline,...
                    '      SAMPLES  - Sample number which shoul be overwritten.',Newline,Newline,...
                    'In OVERWRITE mode, SQDWRITE writes over the data at',Newline,...
                    'the location specified by Channelnumber and sample ',Newline,...
                    'number. It returns an error if there is no data at ',Newline,...
                    'the specified location. If Channel number and/or Sample number',Newline,...
                    'are not provided, SQDWRITE assumes default values, ie',Newline,...
                    'ALL channels and ALL samples respectively',Newline,Decoration,Newline,...
                    'Still to come in SQDWRITE:',Newline,...
                    '1. Deleting data',Newline,...
                    '2. Deleting entire channels',Newline,...
                    '3. Writing a file from SQDHANDLE and DATA (without template)',Newline,...
                    Decoration,Newline];
            disp(txt);
        end;
                
                
        
    case 'sqdhandle'
        if isempty(Running),sqddemo('init');end;
        if Running
            clc
            txt = [Decoration,'SQDHANDLE is a MATLAB class. It is used to hold',Newline,...
                    'various information regarding the Data Acquisition',Newline,...
                    'parameters used in the MEG experiment.',Newline,...
                    'Examples: Version and system info, amplifier gain, sensitivity',Newline,...
                    '         Sampling Rate, data duration, channel count',Newline,...
                    'The different properties of sqdhandle can be viewed in the',Newline,...
                    'help for sqdhandle.',Newline,Newline...
                    'The values of these properties can be viewed by using any of the',Newline,...
                    'following methods :',Newline,...
                    'To view a PROPERTY of object A:',Newline',...
                    '   val = A.PROPERTY;    Ex. A.Version, A.version (case insensitive)',Newline,...
                    '   val = get(A,''PROPERTY'')   Ex. get(A,''Version''), get(A,''version'')',Newline,...
                    'To see all the properties: ',Newline,...
                    '   get(A),disp(A),display(A) ',Newline,Newline,...
                    'Similarly, to set the value of any of the properties of SQDHANDLE',Newline,...
                    '   A.PROPERTY = val;    Ex. A.Version = 1;',Newline,...
                    '   A = set(A,''PROPERTY'',val);  Ex. A = set(A,''version'',1);',Newline,Newline,...
                    '   set(A,''PROPERTY'') shows you which values the PROPERTY can take',Newline,Newline,...
                    'SQDHANDLE inherits from ACQPARAM and hence the properties of ',Newline,...
                    'ACQPARAM are also encapsulated in SQDHANDLE',Newline,Decoration];
            disp(txt);
        end;
                
 end;

function running = uicontinue(key)
newline = sprintf('\n');
valid = 0;
if ~nargin,key = '';end;
while ~valid,
    disp([key,newline]);
    w = input('Press Enter to continue or Q to quit ','s');
    if isempty(w)
        valid = 1;
        running = 1;
    elseif strncmpi(w,'q',1)
        valid = 1;
        running = 0;        
    end;
end;