/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

public class SignalUtil {
    public static int convert24BitByteArrayToInt(byte[] data, int inputDataOffset, boolean signed, boolean networkOrder) {
        int rVal = 0;
        int byte0 = inputDataOffset;
        int byte1 = inputDataOffset + 1;
        int byte2 = inputDataOffset + 2;
        if (networkOrder) {
            rVal = data[byte2] & 0xFF | data[byte1] << 8 & 0xFF00 | data[byte0] << 16 & 0xFF0000;
            if (signed && data[byte0] < 0) {
                rVal |= 0xFF000000;
            }
        } else {
            rVal = data[byte0] & 0xFF | data[byte1] << 8 & 0xFF00 | data[byte2] << 16 & 0xFF0000;
            if (signed && data[byte2] < 0) {
                rVal |= 0xFF;
            }
        }
        return rVal;
    }

    public static byte[] intToByteArray(int value, boolean flipBytes) {
        byte[] rVal = null;
        rVal = flipBytes ? new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)} : new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return rVal;
    }

    public static byte[] packSignalInfo(int signalDepth, int signalFrequency) {
        byte[] rVal = null;
        rVal = new byte[]{(byte)signalDepth, (byte)signalFrequency, (byte)(signalFrequency >> 8), (byte)(signalFrequency >> 16)};
        return rVal;
    }

    public static int[] unpackSignalInfo(byte[] signalInfo) {
        int[] rVal = null;
        int signalDepthOffset = 1;
        rVal = new int[]{signalInfo[0], SignalUtil.convert24BitByteArrayToInt(signalInfo, signalDepthOffset, false, false)};
        return rVal;
    }
}

