/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.AnatomyEGIA;
import com.egi.services.mff.api.Categories;
import com.egi.services.mff.api.Coordinates;
import com.egi.services.mff.api.DipoleSet;
import com.egi.services.mff.api.Epochs;
import com.egi.services.mff.api.EventTrack;
import com.egi.services.mff.api.Fields;
import com.egi.services.mff.api.GeometryEGIG;
import com.egi.services.mff.api.History;
import com.egi.services.mff.api.Info;
import com.egi.services.mff.api.InfoN;
import com.egi.services.mff.api.JTFCategories;
import com.egi.services.mff.api.MFFFile;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import com.egi.services.mff.api.MovieSyncs;
import com.egi.services.mff.api.Notes;
import com.egi.services.mff.api.PNSSet;
import com.egi.services.mff.api.PhoticStimRunFile;
import com.egi.services.mff.api.SensorLayout;
import com.egi.services.mff.api.Signal;
import com.egi.services.mff.api.Subject;
import com.egi.services.mff.interfaces.MFFFactoryDelegate;
import com.egi.services.mff.utility.LocalSignalFile;
import com.egi.services.mff.utility.XMLLocalFileResource;
import com.egi.services.mff.utility.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalMFFFactoryDelegate
implements MFFFactoryDelegate {
    @Override
    public boolean resourceExistsAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && resourceType != null) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case kMFF_RT_MFFFile: 
                case kMFF_RT_Photogrammetry: {
                    rVal = file.isDirectory();
                    break;
                }
                case kMFF_RT_Signal: 
                case kMFF_RT_EventTrack: 
                case kMFF_RT_Epochs: 
                case kMFF_RT_Subject: 
                case kMFF_RT_History: 
                case kMFF_RT_Info: 
                case kMFF_RT_InfoN: 
                case kMFF_RT_Categories: 
                case kMFF_RT_SensorLayout: 
                case kMFF_RT_Coordinates: 
                case kMFF_RT_PNSSet: 
                case kMFF_RT_DipoleSet: 
                case kMFF_RT_Fields: 
                case kMFF_RT_Notes: 
                case kMFF_RT_JTFCategories: 
                case kMFF_RT_MovieSyncs: 
                case kMFF_RT_PhoticStim: 
                case kMFF_RT_GTENModulationConfiguratonFile: 
                case kMFF_RT_GeometryEGIG: 
                case kMFF_RT_AnatomyEGIA: {
                    rVal = file.isFile();
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean createResourceAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && resourceType != null) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case kMFF_RT_MFFFile: 
                case kMFF_RT_Photogrammetry: {
                    try {
                        File contentsFile;
                        rVal = file.mkdir();
                        if (!rVal || !(rVal = (contentsFile = new File(file, "Contents")).mkdir())) break;
                        File pkgInfoFile = new File(contentsFile, "PkgInfo");
                        FileUtils.writeStringToFile(pkgInfoFile, "MFFrNETs");
                        File infoPlist = new File(contentsFile, "Info.plist");
                        Document document = XMLUtil.newXMLDocument();
                        document.setXmlStandalone(true);
                        Element root = document.createElement("plist");
                        root.setAttribute("version", "1.0");
                        Element dictNode = document.createElement("dict");
                        XMLUtil.appendChild(dictNode, "key", "CFBundleName", false, document);
                        switch (resourceType.getResourceType()) {
                            case kMFF_RT_Photogrammetry: {
                                XMLUtil.appendChild(dictNode, "string", "Net Station Photogrammetry Recording", false, document);
                                break;
                            }
                            default: {
                                XMLUtil.appendChild(dictNode, "string", "Net Station MFF Recording", false, document);
                            }
                        }
                        XMLUtil.appendChild(dictNode, "key", "CFBundlePackageType", false, document);
                        XMLUtil.appendChild(dictNode, "string", "MFFr", false, document);
                        XMLUtil.appendChild(dictNode, "key", "CFBundleSignature", false, document);
                        XMLUtil.appendChild(dictNode, "string", "NETs", false, document);
                        root.appendChild(dictNode);
                        document.appendChild(root);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        transformer.setOutputProperty("standalone", "yes");
                        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("doctype-public", "-//Apple Computer//DTD PLIST 1.0//EN");
                        transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
                        XMLUtil.transformDOMtoURI(infoPlist.getPath(), null, document, transformer, false);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                        rVal = false;
                    }
                    break;
                }
                case kMFF_RT_Signal: 
                case kMFF_RT_EventTrack: 
                case kMFF_RT_Epochs: 
                case kMFF_RT_Subject: 
                case kMFF_RT_History: 
                case kMFF_RT_Info: 
                case kMFF_RT_InfoN: 
                case kMFF_RT_Categories: 
                case kMFF_RT_SensorLayout: 
                case kMFF_RT_Coordinates: 
                case kMFF_RT_PNSSet: 
                case kMFF_RT_DipoleSet: 
                case kMFF_RT_Fields: 
                case kMFF_RT_Notes: 
                case kMFF_RT_JTFCategories: 
                case kMFF_RT_MovieSyncs: 
                case kMFF_RT_PhoticStim: 
                case kMFF_RT_GTENModulationConfiguratonFile: 
                case kMFF_RT_GeometryEGIG: 
                case kMFF_RT_AnatomyEGIA: {
                    try {
                        rVal = file.createNewFile();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean deleteResourceAtURI(String uri, MFFResourceType resourceType) {
        boolean rVal = false;
        if (uri != null && this.resourceExistsAtURI(uri, resourceType)) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case kMFF_RT_MFFFile: 
                case kMFF_RT_Photogrammetry: {
                    rVal = file.delete();
                    break;
                }
                case kMFF_RT_Signal: 
                case kMFF_RT_EventTrack: 
                case kMFF_RT_Epochs: 
                case kMFF_RT_Subject: 
                case kMFF_RT_History: 
                case kMFF_RT_Info: 
                case kMFF_RT_InfoN: 
                case kMFF_RT_Categories: 
                case kMFF_RT_SensorLayout: 
                case kMFF_RT_Coordinates: 
                case kMFF_RT_PNSSet: 
                case kMFF_RT_DipoleSet: 
                case kMFF_RT_Fields: 
                case kMFF_RT_Notes: 
                case kMFF_RT_JTFCategories: 
                case kMFF_RT_MovieSyncs: 
                case kMFF_RT_PhoticStim: 
                case kMFF_RT_GTENModulationConfiguratonFile: 
                case kMFF_RT_GeometryEGIG: 
                case kMFF_RT_AnatomyEGIA: {
                    rVal = file.delete();
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean moveResourceAtURI(String sourceURI, String destinationURI, MFFResourceType resourceType) {
        boolean rVal = false;
        if (sourceURI != null && destinationURI != null && this.resourceExistsAtURI(sourceURI, resourceType)) {
            File sourceFile = new File(sourceURI);
            File destinationFile = new File(destinationURI);
            try {
                switch (resourceType.getResourceType()) {
                    case kMFF_RT_MFFFile: 
                    case kMFF_RT_Photogrammetry: {
                        FileUtils.moveDirectoryToDirectory(sourceFile, destinationFile, true);
                        rVal = true;
                        break;
                    }
                    case kMFF_RT_Signal: 
                    case kMFF_RT_EventTrack: 
                    case kMFF_RT_Epochs: 
                    case kMFF_RT_Subject: 
                    case kMFF_RT_History: 
                    case kMFF_RT_Info: 
                    case kMFF_RT_InfoN: 
                    case kMFF_RT_Categories: 
                    case kMFF_RT_SensorLayout: 
                    case kMFF_RT_Coordinates: 
                    case kMFF_RT_PNSSet: 
                    case kMFF_RT_DipoleSet: 
                    case kMFF_RT_Fields: 
                    case kMFF_RT_Notes: 
                    case kMFF_RT_JTFCategories: 
                    case kMFF_RT_MovieSyncs: 
                    case kMFF_RT_PhoticStim: 
                    case kMFF_RT_GTENModulationConfiguratonFile: 
                    case kMFF_RT_GeometryEGIG: 
                    case kMFF_RT_AnatomyEGIA: {
                        FileUtils.moveFileToDirectory(sourceFile, destinationFile, true);
                        rVal = true;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                rVal = false;
            }
        }
        return rVal;
    }

    @Override
    public boolean copyResourceAtURI(String sourceURI, String destinationURI, MFFResourceType resourceType) {
        boolean rVal = false;
        if (sourceURI != null && destinationURI != null && this.resourceExistsAtURI(sourceURI, resourceType)) {
            File sourceFile = new File(sourceURI);
            File destinationFile = new File(destinationURI);
            try {
                switch (resourceType.getResourceType()) {
                    case kMFF_RT_MFFFile: 
                    case kMFF_RT_Photogrammetry: {
                        FileUtils.copyDirectory(sourceFile, destinationFile);
                        rVal = true;
                        break;
                    }
                    case kMFF_RT_Signal: 
                    case kMFF_RT_EventTrack: 
                    case kMFF_RT_Epochs: 
                    case kMFF_RT_Subject: 
                    case kMFF_RT_History: 
                    case kMFF_RT_Info: 
                    case kMFF_RT_InfoN: 
                    case kMFF_RT_Categories: 
                    case kMFF_RT_SensorLayout: 
                    case kMFF_RT_Coordinates: 
                    case kMFF_RT_PNSSet: 
                    case kMFF_RT_DipoleSet: 
                    case kMFF_RT_Fields: 
                    case kMFF_RT_Notes: 
                    case kMFF_RT_JTFCategories: 
                    case kMFF_RT_MovieSyncs: 
                    case kMFF_RT_PhoticStim: 
                    case kMFF_RT_GTENModulationConfiguratonFile: 
                    case kMFF_RT_GeometryEGIG: 
                    case kMFF_RT_AnatomyEGIA: {
                        FileUtils.copyFile(sourceFile, destinationFile);
                        rVal = true;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LocalMFFFactoryDelegate.class.getName()).log(Level.SEVERE, null, ex);
                rVal = false;
            }
        }
        return rVal;
    }

    @Override
    public MFFResource openResourceAtURI(String uri, MFFResourceType resourceType) {
        MFFResource rVal = null;
        if (uri != null && this.resourceExistsAtURI(uri, resourceType)) {
            File file = new File(uri);
            switch (resourceType.getResourceType()) {
                case kMFF_RT_MFFFile: {
                    rVal = new MFFFile(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Signal: {
                    rVal = new Signal(uri, new LocalSignalFile(uri), resourceType);
                    break;
                }
                case kMFF_RT_Photogrammetry: {
                    break;
                }
                case kMFF_RT_EventTrack: {
                    rVal = new EventTrack(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Epochs: {
                    rVal = new Epochs(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Subject: {
                    rVal = new Subject(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_History: {
                    rVal = new History(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Info: {
                    rVal = new Info(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_InfoN: {
                    rVal = new InfoN(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Categories: {
                    rVal = new Categories(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_SensorLayout: {
                    rVal = new SensorLayout(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Coordinates: {
                    rVal = new Coordinates(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_PNSSet: {
                    rVal = new PNSSet(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_DipoleSet: {
                    rVal = new DipoleSet(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Fields: {
                    rVal = new Fields(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_Notes: {
                    rVal = new Notes(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_JTFCategories: {
                    rVal = new JTFCategories(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_MovieSyncs: {
                    rVal = new MovieSyncs(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_PhoticStim: {
                    rVal = new PhoticStimRunFile(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_GeometryEGIG: {
                    rVal = new GeometryEGIG(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
                case kMFF_RT_AnatomyEGIA: {
                    rVal = new AnatomyEGIA(uri, new XMLLocalFileResource(), resourceType);
                    break;
                }
            }
        }
        return rVal;
    }

    @Override
    public boolean closeResource(MFFResource resource) {
        boolean rVal = true;
        return rVal;
    }
}

