/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;

public class MFFUtil {
    public static final String MFF_API_VERSION = "1.0";
    public static final String SpaceSeparator = " ";
    public static final String CommaSeparator = ",";

    public static long getSecondFractionInMicroseconds(String lexicalXSDTime) {
        long rVal = 0L;
        int indexOfDot = lexicalXSDTime.lastIndexOf(46);
        String secondFractionString = null;
        if (indexOfDot != -1 && indexOfDot != lexicalXSDTime.length() - 1) {
            String beyondTheDot = lexicalXSDTime.substring(indexOfDot);
            int indexOfMinus = beyondTheDot.lastIndexOf(45);
            int indexOfPlus = beyondTheDot.lastIndexOf(43);
            secondFractionString = indexOfMinus != -1 ? beyondTheDot.substring(0, indexOfMinus) : (indexOfPlus != -1 ? beyondTheDot.substring(0, indexOfPlus) : beyondTheDot);
            double secondFraction = Double.parseDouble(secondFractionString);
            rVal = (long)(secondFraction * 1000000.0);
        }
        return rVal;
    }

    public static String appendSubMillisecondMicroseconds(long microseconds, String dateTime) {
        String rVal = null;
        int indexOfMinus = dateTime.lastIndexOf(45);
        int indexOfPlus = dateTime.lastIndexOf(43);
        int indexOfDot = dateTime.lastIndexOf(46);
        String theMicrosecondString = null;
        theMicrosecondString = microseconds == 0L ? "" : Long.toString(microseconds);
        int numberOfZeros = 0;
        numberOfZeros = indexOfDot == -1 ? 6 - theMicrosecondString.length() : 3 - theMicrosecondString.length();
        for (int i = 0; i < numberOfZeros; ++i) {
            theMicrosecondString = "0" + theMicrosecondString;
        }
        if (indexOfDot == -1) {
            theMicrosecondString = "." + theMicrosecondString;
        }
        rVal = indexOfMinus != -1 ? dateTime.substring(0, indexOfMinus) + theMicrosecondString + dateTime.substring(indexOfMinus, dateTime.length()) : (indexOfPlus != -1 ? dateTime.substring(0, indexOfPlus) + theMicrosecondString + dateTime.substring(indexOfMinus, dateTime.length()) : dateTime + theMicrosecondString);
        return rVal;
    }

    public static long getTimeInMicroseconds(String lexicalXSDTime) {
        long timeInMilliseconds = MFFUtil.parseDateTime(lexicalXSDTime).getTimeInMillis();
        long fractionalTimeInMicroseconds = MFFUtil.getSecondFractionInMicroseconds(lexicalXSDTime);
        long timeInMicroseconds = timeInMilliseconds * 1000L + (fractionalTimeInMicroseconds - fractionalTimeInMicroseconds / 1000L * 1000L);
        return timeInMicroseconds;
    }

    public static Calendar parseDateTime(String lexicalXSDTime) {
        return DatatypeConverter.parseDateTime((String)lexicalXSDTime);
    }

    public static long getTimeDifferenceInMillis(String lexicalXSDTime1, String lexicalXSDTime2) {
        return MFFUtil.parseDateTime(lexicalXSDTime1).getTimeInMillis() - MFFUtil.parseDateTime(lexicalXSDTime2).getTimeInMillis();
    }

    public static long getTimeDifferenceInMicroseconds(String lexicalXSDTime1, String lexicalXSDTime2) {
        return MFFUtil.getTimeInMicroseconds(lexicalXSDTime1) - MFFUtil.getTimeInMicroseconds(lexicalXSDTime2);
    }

    public static TimeZone getTimeZone(String lexicalXSDTime) {
        TimeZone rVal = null;
        Calendar calendar = DatatypeConverter.parseDateTime((String)lexicalXSDTime);
        if (calendar != null) {
            rVal = calendar.getTimeZone();
        }
        return rVal;
    }

    public static String getDateTime(long microseconds, TimeZone timeZone) {
        String dataTime;
        String rVal = null;
        long milliseconds = microseconds / 1000L;
        long subMilliseconds = microseconds - milliseconds * 1000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        if ((dataTime = DatatypeConverter.printDateTime((Calendar)calendar)) != null) {
            dataTime = MFFUtil.appendSubMillisecondMicroseconds(subMilliseconds, dataTime);
        } else {
            System.out.println("MFFUtil.getDateTime(...) could not get datetime string");
        }
        rVal = dataTime;
        return rVal;
    }

    public static Vector<Integer> stringToVector(String str, String seperator) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] sData = str.split(seperator);
        Vector<Integer> list = new Vector<Integer>();
        for (int i = 0; i < sData.length; ++i) {
            list.add(new Integer(sData[i].trim()));
        }
        return list;
    }

    public static Vector<Integer> commaStringToVector(String str) {
        return MFFUtil.stringToVector(str, CommaSeparator);
    }

    public static Vector<Integer> spaceStringToVector(String str) {
        return MFFUtil.stringToVector(str, SpaceSeparator);
    }

    public static String vectorToString(Vector<Integer> list, String seperator) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            buf.append(Integer.valueOf(list.get(i)).toString());
            buf.append(i < list.size() - 1 ? seperator : "");
        }
        return buf.toString();
    }

    public static String vectorToCommaString(Vector<Integer> list) {
        return MFFUtil.vectorToString(list, CommaSeparator);
    }

    public static String vectorToSpaceString(Vector<Integer> list) {
        return MFFUtil.vectorToString(list, SpaceSeparator);
    }

    public static void updateXMLVersion(String uri) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(uri, new String[0])));
            Files.copy(Paths.get(uri, new String[0]), Paths.get(uri + ".bak", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            String newString = content.replaceFirst("xml version=\"1.0\"", "xml version=\"1.1\"");
            Files.write(Paths.get(uri, new String[0]), newString.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            System.out.println("Error fixing file.");
        }
    }
}

