/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.Event;
import com.egi.services.mff.api.Key;
import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventTrack
extends MFFResource {
    public static final String classID = "EVCK";
    private static String APP_NAME = "EventTrack";
    private static String USAGE = "EventTrack Unit Test\nUsage: EventTrack [OPTIONS]\nwhere [OPTIONS] are:\n-f, --input_filename .................. event track file (default: ~/MFF_Unit_Tests/EventTrack/Events_ECI.xml).\n-o, --outut_filename .................. output epochs file (default: ~/MFF_Unit_Tests/EventTrack/Events_ECI_output.xml).\n-h, -help ...................................... display this help message.\n";
    public static final String SchemaFileName = "event_mff";
    public static final String SaveFilePrefix = "Events";
    protected String name = null;
    protected String trackType = null;
    protected ArrayList<Event> events = null;

    public EventTrack() {
    }

    public EventTrack(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public EventTrack copy() throws CloneNotSupportedException {
        return (EventTrack)this.clone();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTrackType(String trackType) {
        this.trackType = trackType;
    }

    public String getTrackType() {
        return this.trackType;
    }

    public void setEvents(ArrayList<Event> events) {
        this.events = events;
    }

    public ArrayList<Event> getEvents() {
        return this.events;
    }

    public String getClassID() {
        return classID;
    }

    public static void main(String[] args) {
        boolean error = false;
        try {
            MFFFactory factory;
            MFFResource resource;
            String userDirectory = System.getProperty("user.dir");
            String defaultInputURI = userDirectory + "/MFF_Unit_Tests/EventTrack/Events_ECI.xml";
            String defaultOutputURI = userDirectory + "/MFF_Unit_Tests/EventTrack/Events_ECI_output.xml";
            CmdLineParser commandLineParser = new CmdLineParser();
            CmdLineParser.Option inputFileOpt = commandLineParser.addStringOption('f', "filename");
            CmdLineParser.Option outputFileOpt = commandLineParser.addStringOption('o', "output_filename");
            CmdLineParser.Option helpOpt = commandLineParser.addBooleanOption('h', "help");
            try {
                commandLineParser.parse(args);
            }
            catch (CmdLineParser.OptionException e) {
                System.err.println(e.getMessage());
                System.err.println(USAGE);
                System.exit(-1);
            }
            String inputURI = (String)commandLineParser.getOptionValue(inputFileOpt);
            String outputURI = (String)commandLineParser.getOptionValue(outputFileOpt);
            Boolean help = (Boolean)commandLineParser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                System.err.println(USAGE);
                System.exit(0);
            }
            if (inputURI == null) {
                inputURI = defaultInputURI;
            }
            if (outputURI == null) {
                outputURI = defaultOutputURI;
            }
            if ((resource = (factory = new MFFFactory(new LocalMFFFactoryDelegate())).openResourceAtURI(inputURI, new MFFResourceType(3))) instanceof EventTrack) {
                EventTrack eventTrack = (EventTrack)resource;
                if (eventTrack.loadResource()) {
                    System.out.println("EventTrack: ------");
                    System.out.println("EventTrack: name: " + eventTrack.getName());
                    System.out.println("EventTrack: type: " + eventTrack.getTrackType());
                    System.out.println("EventTrack: events:" + eventTrack.getName());
                    ArrayList<Event> events = eventTrack.getEvents();
                    if (events != null) {
                        for (Event event : events) {
                            System.out.println("EventTrack: ------");
                            System.out.println("EventTrack: event:");
                            System.out.println("EventTrack:    begin time: " + event.getBeginTime());
                            System.out.println("EventTrack:    duration: " + event.getDuration());
                            System.out.println("EventTrack:    code: " + event.getCode());
                            System.out.println("EventTrack:    label: " + event.getLabel());
                            System.out.println("EventTrack:    description: " + event.getDescription());
                            System.out.println("EventTrack:    source device: " + event.getSourceDevice());
                            System.out.println("EventTrack: ------");
                            System.out.println("EventTrack:    keys:");
                            ArrayList<Key> keys = event.getKeys();
                            if (keys == null) continue;
                            for (Key key : keys) {
                                System.out.println("EventTrack: ------");
                                System.out.println("EventTrack:    key:");
                                System.out.println("EventTrack:       key code: " + key.getCode());
                                System.out.println("EventTrack:       description: " + key.getDescription());
                                System.out.println("EventTrack:       data: " + key.getData());
                                System.out.println("EventTrack:       data type: " + key.getDataType());
                            }
                        }
                    }
                    System.out.println("EventTrack: ------");
                    eventTrack.setURI(outputURI);
                    eventTrack.saveResource();
                } else {
                    System.out.println("EventTrack: error: unable to load resource: " + inputURI);
                }
                factory.closeResource(eventTrack);
            } else {
                System.out.println("EventTrack: error: unable to open resource: " + inputURI);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(EventTrack.class.getName()).log(Level.SEVERE, null, ex);
            error = true;
        }
        if (error) {
            System.exit(-1);
        } else {
            System.exit(0);
        }
    }
}

