/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.Epoch;
import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Epochs
extends MFFResource {
    public static final String classID = "EPHS";
    private static String APP_NAME = "Epochs";
    private static String USAGE = "Epochs Unit Test\nUsage: Epochs [OPTIONS]\nwhere [OPTIONS] are:\n-f, --input_filename .................. epochs file (default: ~/MFF_Unit_Tests/Epochs/epochs.xml).\n-o, --outut_filename .................. output epochs file (default: ~/MFF_Unit_Tests/Epochs/epochs_output.xml).\n-h, -help ...................................... display this help message.\n";
    public static final String SchemaFileName = "epochs_mff";
    public static final String SaveFilePrefix = "epochs";
    private ArrayList<Epoch> epochs = null;

    public Epochs() {
    }

    public Epochs(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public Epochs copy() throws CloneNotSupportedException {
        return (Epochs)this.clone();
    }

    public void setEpochs(ArrayList<Epoch> epochs) {
        this.epochs = epochs;
    }

    public ArrayList<Epoch> getEpochs() {
        return this.epochs;
    }

    public String getClassID() {
        return classID;
    }

    public static void main(String[] args) {
        boolean error = false;
        try {
            MFFFactory factory;
            MFFResource resource;
            String userDirectory = System.getProperty("user.dir");
            String defaultInputURI = userDirectory + "/MFF_Unit_Tests/Epochs/epochs.xml";
            String defaultOutputURI = userDirectory + "/MFF_Unit_Tests/Epochs/epochs_output.xml";
            CmdLineParser commandLineParser = new CmdLineParser();
            CmdLineParser.Option inputFileOpt = commandLineParser.addStringOption('f', "filename");
            CmdLineParser.Option outputFileOpt = commandLineParser.addStringOption('o', "output_filename");
            CmdLineParser.Option helpOpt = commandLineParser.addBooleanOption('h', "help");
            try {
                commandLineParser.parse(args);
            }
            catch (CmdLineParser.OptionException e) {
                System.err.println(e.getMessage());
                System.err.println(USAGE);
                System.exit(-1);
            }
            String inputURI = (String)commandLineParser.getOptionValue(inputFileOpt);
            String outputURI = (String)commandLineParser.getOptionValue(outputFileOpt);
            Boolean help = (Boolean)commandLineParser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                System.err.println(USAGE);
                System.exit(0);
            }
            if (inputURI == null) {
                inputURI = defaultInputURI;
            }
            if (outputURI == null) {
                outputURI = defaultOutputURI;
            }
            if ((resource = (factory = new MFFFactory(new LocalMFFFactoryDelegate())).openResourceAtURI(inputURI, new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_Epochs))) instanceof Epochs) {
                Epochs epochs = (Epochs)resource;
                if (epochs.loadResource()) {
                    ArrayList<Epoch> epochsList = epochs.getEpochs();
                    System.out.println("epoch unit test: epochs:");
                    for (Epoch epoch : epochsList) {
                        System.out.println("epoch unit test: ------");
                        System.out.println("epoch unit test: epoch");
                        System.out.println("epoch unit test:    begin time: " + epoch.getBeginTime());
                        System.out.println("epoch unit test:    end time: " + epoch.getEndTime());
                        System.out.println("epoch unit test:    first block: " + epoch.getFirstBlock());
                        System.out.println("epoch unit test:    last block: " + epoch.getLastBlock());
                    }
                    System.out.println("epoch unit test: ------");
                    epochs.setURI(outputURI);
                    epochs.saveResource();
                } else {
                    System.out.println("epoch unit test: error: unable to load resource: " + inputURI);
                }
            } else {
                System.out.println("epoch unit test: error: unable to open resource: " + inputURI);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Epochs.class.getName()).log(Level.SEVERE, null, ex);
            error = true;
        }
        if (error) {
            System.exit(-1);
        } else {
            System.exit(0);
        }
    }
}

