/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.SqlXmlUtil;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class BinaryOperatorNode
extends ValueNode {
    String operator;
    String methodName;
    ValueNode receiver;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int CONCATENATE = 5;
    public static final int EQ = 6;
    public static final int NE = 7;
    public static final int GT = 8;
    public static final int GE = 9;
    public static final int LT = 10;
    public static final int LE = 11;
    public static final int AND = 12;
    public static final int OR = 13;
    public static final int LIKE = 14;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String leftInterfaceType;
    String rightInterfaceType;
    String resultInterfaceType;
    int operatorType;
    public static final int XMLEXISTS_OP = 0;
    public static final int XMLQUERY_OP = 1;
    static final String[] BinaryOperators = new String[]{"xmlexists", "xmlquery"};
    static final String[] BinaryMethodNames = new String[]{"XMLExists", "XMLQuery"};
    static final String[] BinaryResultTypes = new String[]{"org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    static final String[][] BinaryArgTypes = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}};
    private SqlXmlUtil sqlxUtil;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.leftOperand = (ValueNode)object;
        this.rightOperand = (ValueNode)object2;
        this.operator = (String)object3;
        this.methodName = (String)object4;
        this.leftInterfaceType = (String)object5;
        this.rightInterfaceType = (String)object6;
        this.operatorType = -1;
    }

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.leftOperand = (ValueNode)object;
        this.rightOperand = (ValueNode)object2;
        this.leftInterfaceType = (String)object3;
        this.rightInterfaceType = (String)object4;
        this.operatorType = -1;
    }

    public void init(Object object, Object object2, Object object3) {
        this.leftOperand = (ValueNode)object;
        this.rightOperand = (ValueNode)object2;
        this.operatorType = (Integer)object3;
        this.operator = BinaryOperators[this.operatorType];
        this.methodName = BinaryMethodNames[this.operatorType];
        this.leftInterfaceType = BinaryArgTypes[this.operatorType][0];
        this.rightInterfaceType = BinaryArgTypes[this.operatorType][1];
        this.resultInterfaceType = BinaryResultTypes[this.operatorType];
    }

    public String toString() {
        return "";
    }

    void setOperator(String string) {
        this.operator = string;
        this.operatorType = -1;
    }

    void setMethodName(String string) {
        this.methodName = string;
        this.operatorType = -1;
    }

    public void setLeftRightInterfaceType(String string) {
        this.leftInterfaceType = string;
        this.rightInterfaceType = string;
        this.operatorType = -1;
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, vector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, vector);
        if (this.operatorType == 0 || this.operatorType == 1) {
            return this.bindXMLQuery();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperand.requiresTypeFromContext()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperand.getTypeServices());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(this.leftOperand.getTypeServices());
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode bindXMLQuery() throws StandardException {
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (!(this.leftOperand instanceof CharConstantNode)) {
            throw StandardException.newException("42Z75");
        }
        this.sqlxUtil = new SqlXmlUtil();
        this.sqlxUtil.compileXQExpr(((CharConstantNode)this.leftOperand).getString(), this.operatorType == 0 ? "XMLEXISTS" : "XMLQUERY");
        if (typeId2 != null && !typeId2.isXMLTypeId()) {
            throw StandardException.newException("42Z77", typeId2.getSQLTypeName());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            throw StandardException.newException("42Z70");
        }
        if (this.operatorType == 0) {
            this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else {
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (typeId2.userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((typeId = this.rightOperand.getTypeId()).userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        boolean bl;
        String string;
        boolean bl2;
        Object object;
        if (this instanceof BinaryRelationalOperatorNode && (object = ((BinaryRelationalOperatorNode)this).getInListOp()) != null) {
            ((InListOperatorNode)object).generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        boolean bl3 = bl2 = this.operatorType == 1 || this.operatorType == 0;
        if (bl2) {
            methodBuilder.pushNewStart("org.apache.derby.impl.sql.execute.SqlXmlExecutor");
            methodBuilder.pushNewComplete(this.addXmlOpMethodParams(expressionClassBuilder, methodBuilder));
        }
        if (this.leftOperand.getTypeId().typePrecedence() > this.rightOperand.getTypeId().typePrecedence()) {
            this.receiver = this.leftOperand;
            string = this.operatorType == -1 ? this.getReceiverInterfaceName() : this.leftInterfaceType;
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(string);
            methodBuilder.dup();
            methodBuilder.cast(this.leftInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.rightInterfaceType);
        } else {
            this.receiver = this.rightOperand;
            string = this.operatorType == -1 ? this.getReceiverInterfaceName() : this.rightInterfaceType;
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(string);
            if (!bl2) {
                methodBuilder.dup();
                methodBuilder.cast(this.rightInterfaceType);
            }
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.leftInterfaceType);
            methodBuilder.swap();
        }
        object = this.operatorType == -1 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean bl4 = bl = !this.getTypeId().isBooleanTypeId();
        if (bl) {
            int n;
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, (String)object);
            methodBuilder.getField(localField);
            this.initializeResultField(expressionClassBuilder, methodBuilder, localField);
            if (this.getTypeServices() != null && ((n = this.getTypeServices().getJDBCTypeId()) == 3 || n == 2) && this.operator.equals("/")) {
                methodBuilder.push(this.getTypeServices().getScale());
                methodBuilder.callMethod((short)185, string, this.methodName, (String)object, 4);
            } else if (bl2) {
                methodBuilder.callMethod((short)182, null, this.methodName, (String)object, 3);
            } else {
                methodBuilder.callMethod((short)185, string, this.methodName, (String)object, 3);
            }
            if (this.getTypeId().variableLength() && this.getTypeId().isNumericTypeId()) {
                methodBuilder.dup();
                methodBuilder.push(this.getTypeServices().getPrecision());
                methodBuilder.push(this.getTypeServices().getScale());
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
            }
            methodBuilder.putField(localField);
        } else if (bl2) {
            methodBuilder.callMethod((short)182, null, this.methodName, (String)object, 2);
        } else {
            methodBuilder.callMethod((short)185, string, this.methodName, (String)object, 2);
        }
    }

    protected void initializeResultField(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, LocalField localField) throws StandardException {
    }

    public void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode valueNode) {
        this.rightOperand = valueNode;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.leftOperand.categorize(jBitSet, bl);
        bl2 = this.rightOperand.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.leftOperand.constantExpression(predicateList) && this.rightOperand.constantExpression(predicateList);
    }

    public String getReceiverInterfaceName() throws StandardException {
        return this.receiver.getTypeCompiler().interfaceName();
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = this.leftOperand.getOrderableVariantType();
        int n2 = this.rightOperand.getOrderableVariantType();
        return Math.min(n, n2);
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(visitor);
        }
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeType(valueNode)) {
            return false;
        }
        BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)valueNode;
        return this.methodName.equals(binaryOperatorNode.methodName) && this.leftOperand.isEquivalent(binaryOperatorNode.leftOperand) && this.rightOperand.isEquivalent(binaryOperatorNode.rightOperand);
    }

    private int addXmlOpMethodParams(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.sqlxUtil));
        return 2;
    }
}

