.ds Vn 1.3
.ds Rd 21-February-2005
.TH vgrid 1Vi "21 February 2005" "Public Version \*(Vn" SimBio
.SH NAME
vgrid \- generate a FEM grid from a labelled Vista volume dataset
.SH SYNOPSIS
\fBvgrid\fR [\fB-\fIoption\fR ...] [\fIinfile\fR] [\fIoutfile\fR]

.SH DESCRIPTION
\fBvgrid\fP expects a labelled Vista image in
VShort or VUByte format which contains a maximum number of 256 labelled
regions (for the marching tets algorithms, currently only 2 regions are allowed). 
\fBvgrid\fP converts this voxel dataset into a volumetric mesh
consisting of either cubes or tetrahedra.
.LP
The minimum and maxmimum grid dimensions are selectable by command
line arguments (\fB-min\fP and \fB-max\fP). 
If the minimum is greater than 1, data are subsampled first
by selecting the most frequent label for a target cell. Setting the maximum 
to a value greater than 1 introduces collection of voxels in an octree fashion.
Cubical as well as tetrahedral grids may be generated. Simple cubes with 
8 nodes at the vertices (tetrahedra: 4) are assumed. Thus, the cubical 
grids produced will only well-defined if they are uniform (min == max).
Tetrahedral grids may be non-uniform (min < max).
.LP
In a final step, boundaries may be refined by specifying \fB-smooth shift\fP
or \fB-smooth marching\fP. In the first case, which applies only to uniform hexahedral grids,
nodes close to a boundary at shifted onto the boundary, given a shift constraint as specified by
the argument \fB-shift\fP. The latter case introduces a local refinement
by a tetrahedrization of boundary cells. Note that selecting this option
implies the generation of a tetrahedral mesh.
.LP
A small number of output formats are supported, either a Vista graph file,
a simple ASCII mesh format (3D), the GPPView (GeoFEM) format (3D), the GMV format (2D+3D),
the complex2D format of GrAL (2D), and the format of OpenDX (2D).

.SH "COMMAND LINE OPTIONS"
\fBvgrid\fP accepts the following options:
.IP \fB-help\fP 15n
Prints a message describing options.
.IP "\fB-olevel\fP \fInumber\fP"
Verbosity level. Default: 1.
Level 0 prints only warnings and errors, level 1 prints global values and progress information,
level 2 gives per-cell output, and level 3 gives even more detailed per-cell output.
.IP "\fB-in\fP \fIinfile\fP"
Specifies a Vista data file containing the labelled input image.
.IP "\fB-out\fP \fIoutfile\fP"
Specifies the output file
.IP "\fB-format\fP \fI[hf|vm|ipe|ascii|gmv|gpp|complex2d|dx]\fP"
Specifies the output format. 
(It is easy to adapt \fBvgrid\fP  to output other formats, 
look at mesh::vtoa() and its call in gridGenerator::write() for an example.)
.br
\fIhf\fP selects Vista graph format (default).
.br
\fIvm\fP and \fIipe\fP are variations of the \fIvm\fP format
.br
\fIascii\fP selects a simple home-grown ASCII mesh format. Volume meshes only.
.br
\fIgmv\fP selects the GMV ASCII format (\fIhttp://www-xdiv.lanl.gov/XCM/gmv/GMVHome.html\fP). 
For both surface and volume meshes.
.br
\fIgpp\fP selects the GPPView/GeoFEM format 
(\fIhttp://geofem.tokyo.rist.or.jp/download_en/gppview.html\fP). Volume meshes only.
.br
\fIcomplex2d\fP selects the complex2d format of GrAL (\fIhttp://www.math.tu-cottbus.de/~berti/gral\fP).
For surface meshes only.
.br
\fIdx\fP selects the format of OpenDX (\fIhttp://www.opendx.org\fP).
For both volume and surface meshes.
.IP "\fB-elem\fP \fItype\fP"
Specifies the element type of the FEM grid:
.RS 17n
.PP
.nf
.ta 12n
\fBtetra5\fP	tetrahedra (a cube divided into 5 tetrahedra)
\fBtetra6a\fP	tetrahedra (a cube divided into 6 tetrahedra, linkage a)
\fBtetra6b\fP	tetrahedra (a cube divided into 6 tetrahedra, linkage b)
\fBcube\fP	cubes (default)
.DT
.fi
.RE
.IP ""
This option currently provides a real choice only in the case of a uniform mesh (min=max).
In the non-uniform case, \fBtetra5\fP is automatically selected.
.IP "\fB-min\fP \fInumber\fP"
Specifies the minimum grid dimension (resolution at material interfaces). Default: 4. 
Must be a positive integer. 
This value can be overridden on a per-interface basis by \fIinterface\fP lines
in a material file specified with \fB-material\fP. 
.IP "\fB-max\fP \fInumber\fP"
Specifies the maximum grid dimension (resolution inside a material-homogeneous region). 
Default: 4. Must be a positive integer, and a power-of-two multiple of 
the value specified with \fB-min\fP (will be adapted otherwise).
This value can be overridden on a per-material basis by \fImaterial\fP lines
in a material file specified with \fB-material\fP.
.IP "\fB-smooth\fP \fItype\fP"
.RS 17n
.PP
.nf
.ta 12n
\fBno\fP	no boundary smoothing (default)
\fBshift\fP	shift boundary nodes (uniform hexahedral meshes only, min=max)
\fBmarching\fP	refine mesh locally by introducing tetrahedra
.DT
.fi
.RE
.IP "\fB-shift\fP \fInumber\fP"
Specifies the degree of shifting, must be between 0.0 and 0.49. Default: 0.49.
This option only applies if \fBshift\fP is selected for the \fB-smooth\fP option.
Note: excessive smoothing can degrade the quality of the hex cells.
.IP "\fB-sm_iters\fP \fInumber\fP"
Specifies the number of iterations for node shifting after marching tetrahedra.
Default: 0 (no smoothing).
.IP "\fB-sm_weights\fP \fIname\fP"
Specifies a file containing weights for surface smoothing. The number(s) in this file should
be within -1 and 1. A single number corresponds to usual Laplacian smoothing with this parameter
(1.0 means each surface vertex is moved to the barycenter of its neighbors on the surface).
If there are two or more numbers, there will be \fB-sm_iters\fP cycles through this file,
using the numbers in turn as parameters of single Laplacian smoothing steps.
For instance, putting the numbers 0.5 and -0.5 in the file reduces shrinking. 
Google for "smoothing without shrinking".
.IP "\fB-vsm_weights\fP \fIname\fP"
Specifies a file containing weights for volume smoothing (ie. smoothing of interior vertices).
This is necessary to avoid degradation of the quality of tetrahedral cells.
Volume smoothing is interleaved with surface smoothing: After each Laplacian surface smoothing
iteration, there is a Laplacian smoothing iteration of the interior vertices.
In order to force different interleaving patterns 
(e.g. volumetric smoothing only every three surface smoothing iterations),
one has to insert an appropriate number of zeros into the volumetric smoothing weights file
(2 zeros and the non-zero smoothing parameter in this example).
If this file contains a smoothing value of 0.0, no volume smoothing is performed.
If no file is present, a default value of 0.5 is used.
.IP "\fB-surface\fP \fI[true|false]\fP"
If set, only a surface mesh is generated. Implies \fB-smooth marching\fP.
Default: false.
.IP "\fB-material\fP \fIname\fP"
Name of an optional parameter file specifying material-dependent meshing information. 
See the "FILES" section for more information.

.IP "\fBThe following options are only useful in the SimBio context:\fP"
.IP "\fB-simbio_mat_ids\fP \fI[true|false]\fP"
Use material IDs specified in the SimBio project. Implies the use of a material file
(\fB-material\fP option) with the correct SimBio material names.
.IP "\fB-matdb\fP \fIname\fP"
Read material names and IDs from file, instead of using library version.
Has an effect only if \fB-simbio_mat_ids\fP is selected.
.IP "\fB-explicit_links\fP \fI[true|false]\fP"
Write explicit vertex-vertex connectivity to the Vista output. Default: false.
.IP "\fB-nofields\fP" 
Do not write any fields, except materials. Default: false.
.IP "\fB-constraint\fP"
Specifies the fixity constraints to be applied to grid nodes:
.RS 17n
.PP
.nf
.ta 12n
\fBno\fP     none
\fBbox\fP    read constraints from file \fBbox.con\fP. 
       Constraint nodes lie in a box:
.RS 12n
.PP
.nf
.ta 12n 
  ConstraintID
  xmin ymin zmin
  xdim ydim zdim
.DT
.fi
.RE
\fBplane\fP  read constraints from file \fBplane.con\fP. 
       Constraint nodes lie in a plane:
.RS 12n
.PP
.nf
.ta 12n 
ConstraintID
plane_dir       (Orientation of plane 1: xy, 2: yz  3: zx)
plane_pos       (z, x, y position of plane)
.DT
.fi
.RE
\fBsnodes\fP read constraints from file \fBsnodes.con\fP. 
       Constraint nodes are enumerated by giving their integer coordinates:
.RS 12n
.PP
.nf
.ta 12n 
ConstraintID
n     (number of constraint nodes)
x1 y1 z1
...
x_n y_n z_n
.DT
.fi
.RE
.DT
.fi
.RE
.IP "\fB-np\fP \fInumber\fP"
Number of partitions in initial node and element partitionings. 
When using the marching tetrahedra algorithm and a higher number of partitions,
the partitioning is very bad.
.LP
Input and output files can be specified on the command line or allowed to
default to the standard input and output streams.

.SH "FILES"
With the \fB-material\fP option, a file containing information for material specific meshing options
can be specified. The syntax of this file is as follows:

.LP
First, a number of lines describing materials, introduced by the keyword \fBmaterial\fP:
.LP
\fBmaterial\fP  <name>  <maxdim>  <lower bd>  <upper bd>   <meshing type>  <weight>
.LP
where
.IP  <name>  
is the name of the material (string)
.IP  <maxdim>  
is the maximal element size of the material (analoguous to the global setting by \fB-max\fP)
.IP  "<lower bd> <upper bd>" 
give the label range of the material, i.e. every label L in [<lower bd> <upper bd>] is considered
having this material
.IP "<meshing type>"
gives the type of meshing. Currently, only  '1' for choosing the global meshing type set via commandline parameters,
and '2' for suppressing meshing of this material are supported.
.IP "<weight>"
gives a weight to the material, which is used when  subsampling the image. For each material,
the number of voxels having this material is multiplied with the weight before selecting the 
majority material. This is a hack to prevent thin structures from disappearing after subsampling.

.LP
Second, the resolution of specific material interfaces can be specified,
overriding the global value given with the \fB-min\fP option. Such lines
have the form
.LP
\fBinterface\fP <mat1> <mat2> <maxdim>
.LP
where
.IP "<mat1> <mat2>"
are two material names given in the materials section before
.IP "<maxdim>"
is a number giving the maximal element size at this material interface, that is, each octree cell
containing voxels of both these materials will be of at most this size.

.LP
In each line, all values must be present. Material and interface lines may be mixed.
In the following example
.LP

.RS 12n
.PP
.nf
.ta 12n 
material  bg           4   0  0    2  1.0
material  skull        2   1  1    1  4.0
material  brain        8   2  6    1  1.0
material  scalp        4   7  7    1  1.0
interface skull  brain  1
interface skull  scalp  1
interface scalp  bg     2
.DT
.fi
.RE

.LP
there are 4 materials (bg, skull, scalp, and brain), having labels 0, 1,  2-6, and 7, respectively.
The material bg (for background) is not meshed, skull is meshed with 2 voxels resolution,
scalp with 4 voxels, and brain with 8 voxels. 
However, the interfaces between brain and skull as well as skull and scalp 
are meshed with 1 voxel resolution.
In contrast, the interface between scalp and bg is meshed only with 2 voxels resolution.
The weight for skull is set to 4.0, which means that an octree cell containing more than 12.5% 
skull voxels will get labeled as skull.
 
.SH "EXAMPLES"

\fBvgrid\fP \fB-in\fP img.v \fB-out\fP mesh.gmv \fB-format\fP gmv \fB-min\fP 1 \fB-max\fP 1 \fB-elem\fP cube
.br
This generates an uniform mesh, where each voxel of the image corresponds to a hexahedral cell of the mesh.

.LP  
\fBvgrid\fP \fB-in\fP img.v \fB-out\fP mesh.gmv \fB-format\fP gmv \fB-min\fP 1 \fB-max\fP 1 \fB-elem\fP tetra5
.br
Generate a uniform mesh, each voxel is represented by 5 tetrahedra.

.LP
\fBvgrid\fP \fB-in\fP img.v \fB-out\fP mesh.gmv \fB-format\fP gmv \fB-min\fP 1 \fB-max\fP 4 \fB-elem\fP tetra5
.br
Generate a non-uniform tetrahedral mesh, with maximal edge length 4 times a voxel diameter.

.LP 
\fBvgrid\fP \fB-in\fP img.v \fB-out\fP mesh.gmv \fB-format\fP gmv \fB-min\fP 1 \fB-max\fP 4 \fB-elem\fP tetra5 \fB-smooth\fP marching 
.br
Generate a non-uniform tetrahedral mesh, the boundary between the two materials is smoothed using 
the marching tets algorithm.
.br
Note: Only 2 materials are allowed here.
 
.LP
\fBvgrid\fP \fB-in\fP img.v \fB-out\fP mesh.gmv \fB-format\fP gmv  \fB-elem\fP tetra5 \fB-material\fP img.mat 
.br
Read material meshing parameters from the file \fIimg.mat\fP

.SH "LIMITATIONS"
The marching tetrahedra algorithms is restricted to the two-material case.
If the image contains more then 2 materials to be meshed, 
vgrid will print a warning and stop.
.LP
The marching tetrahedra algorithm may "eat up" small structures.
.LP
Iterated node shifting for hexahedra may result in distorted elements.
.LP
There may be ugly spikes at the material interface when using non-uniform meshing together
with marching tets - the more imbalanced the octree, the sharper the possible spikes.
.LP
There is no option to balance the octree.

.SH "SEE ALSO"
.BR VImage (3Vi),
.BR VGraph (3Vi),
.BR Vista (7Vi)
.LP
Vgrid homepage  \fI http://www.ccrl-nece.de/vgrid\fP

.SH AUTHORS
Ulrich Hartmann <hartmann@ccrl-nece.de>
.br
Frithjof Kruggel <kruggel@cns.mpg.de>
.br
Guntram Berti <berti@ccrl-nece.de>
