/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import com.egi.services.mff.test.schema.MFFSchema;
import com.egi.services.mff.utility.MFFUtil;
import com.egi.services.mff.utility.ResourceMarshalException;
import com.egi.services.mff.utility.ResourceUnmarshalException;
import com.egi.services.mff.utility.ResourceValidationException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String Indent = "    ";

    public static Document newXMLDocument() throws ResourceMarshalException {
        Document rVal = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            rVal = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException exp) {
            System.out.println("MFFRootDoc: error: " + exp.toString());
            throw new ResourceMarshalException("could not obtain xml engine resources");
        }
        return rVal;
    }

    public static Document getDocumentFromURI(String uri) throws ResourceUnmarshalException {
        Document document = null;
        if (uri != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(new File(uri));
            }
            catch (ParserConfigurationException exp) {
                System.out.println("MFFRootDoc: error: " + exp.toString());
                throw new ResourceUnmarshalException("could not obtain xml engine resources");
            }
            catch (SAXException exp) {
                System.out.println("MFFRootDoc: error: " + exp.toString());
                throw new ResourceUnmarshalException("could not parse from xml resource");
            }
            catch (IOException exp) {
                System.out.println("MFFRootDoc: error: " + exp.toString());
                throw new ResourceUnmarshalException("could not obtain resources");
            }
        }
        return document;
    }

    public static void transformDOMtoURI(String uri, String xsdURI, Document document, Transformer transformer, boolean debug) throws ResourceMarshalException, ResourceValidationException {
        try {
            DOMSource domSource = new DOMSource(document);
            StringWriter documentStringRepresentation = new StringWriter();
            if (transformer == null) {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("standalone", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(domSource, new StreamResult(documentStringRepresentation));
            }
            BufferedWriter xmlWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(uri), "UTF-8"));
            xmlWriter.write(documentStringRepresentation.toString());
            ((Writer)xmlWriter).close();
            if (debug) {
                System.out.println(documentStringRepresentation.toString());
            }
            if (xsdURI != null) {
                XMLUtil.validateDOMSource(domSource, xsdURI);
            }
        }
        catch (TransformerConfigurationException exp) {
            throw new ResourceMarshalException("could not obtain xml engine resources");
        }
        catch (TransformerException exp) {
            throw new ResourceMarshalException("could transform to xml resource");
        }
        catch (IOException exp) {
            throw new ResourceMarshalException("could not obtain resources");
        }
    }

    public static void validateDOMSource(DOMSource domSource, String xsdURI) throws ResourceValidationException {
        if (xsdURI == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                InputStream xsdStream = new MFFSchema().xsdForFile(xsdURI);
                Schema schema = schemaFactory.newSchema(new StreamSource(xsdStream));
                Validator validator = schema.newValidator();
                validator.validate(domSource);
            }
            catch (SAXException exp) {
                throw new ResourceValidationException("could not validate XSD file \"res/schema/" + xsdURI);
            }
            catch (NullPointerException exp) {
                throw new ResourceValidationException("could not obtain xml validation resources");
            }
            catch (IOException exp) {
                throw new ResourceValidationException("could not obtain resource");
            }
        } else {
            throw new ResourceValidationException("could not obtain schema resource: " + xsdURI);
        }
    }

    public static boolean isNodeWithNameAndChildNodes(Node root, String name) {
        return root != null && root.getNodeName().compareTo(name) == 0 && root instanceof Element && root.hasChildNodes();
    }

    public static Node getChildNode(String sTag, Element eElement) {
        NodeList pList = eElement.getElementsByTagName(sTag);
        if (pList.getLength() > 0) {
            return pList.item(0);
        }
        return null;
    }

    public static String getTagValue(String sTag, Element eElement) {
        NodeList pList = eElement.getElementsByTagName(sTag);
        if (pList.getLength() > 0) {
            NodeList cList = pList.item(0).getChildNodes();
            Node cNode = cList.item(0);
            return cNode != null ? cNode.getNodeValue() : "";
        }
        return null;
    }

    public static Element getElement(String name, String text, boolean createEmpty, Document document) {
        Element rVal = null;
        if (createEmpty && text == null) {
            text = "null";
        }
        if (name != null && text != null && document != null) {
            rVal = document.createElement(name);
            rVal.setTextContent(text);
        }
        return rVal;
    }

    public static Node appendChild(Node parent, Node child) {
        Node rVal = parent;
        if (parent != null && child != null) {
            parent.appendChild(child);
        }
        return rVal;
    }

    public static Element appendChild(Node parent, String name, String text, boolean createEmpty, Document document) {
        Element rVal = null;
        if (createEmpty && text == null) {
            text = "null";
        }
        if (name != null && text != null && parent != null && document != null) {
            rVal = document.createElement(name);
            rVal.setTextContent(text);
            parent.appendChild(rVal);
        }
        return rVal;
    }

    public static Element setAttribute(Element element, String name, String value, boolean alwaysCreate) {
        Element rVal = element;
        if (alwaysCreate) {
            if (name == null) {
                name = "";
            }
            if (value == null) {
                value = "";
            }
        }
        if (element != null && name != null && value != null) {
            element.setAttribute(name, value);
        }
        return rVal;
    }

    public static String getAttribute(Node node, String name) {
        Element element;
        String attribute;
        String rVal = "";
        if (node instanceof Element && (attribute = (element = (Element)node).getAttribute(name)) != null) {
            rVal = attribute;
        }
        return rVal;
    }

    public static Vector<String> stringVectorFromNode(Node root, String tagParent, String tagChild) {
        Vector<String> strList = null;
        if (XMLUtil.isNodeWithNameAndChildNodes(root, tagParent)) {
            NodeList list = root.getChildNodes();
            strList = new Vector<String>();
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                String cName = child.getNodeName();
                if (cName.compareTo(tagChild) != 0) continue;
                strList.add(child.getTextContent());
            }
        }
        return strList;
    }

    public static Vector<Object> dataSetFromNode(Node root, String tagParent, String tagChild, boolean space) {
        Vector<Object> dataSet = new Vector<Object>();
        if (XMLUtil.isNodeWithNameAndChildNodes(root, tagParent)) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                String cName = child.getNodeName();
                if (cName.compareTo(tagChild) != 0) continue;
                Vector<Integer> data = space ? MFFUtil.spaceStringToVector(child.getTextContent()) : MFFUtil.commaStringToVector(child.getTextContent());
                dataSet.add(data);
            }
        }
        return dataSet;
    }

    public static Vector<Object> spaceDataSetFromNode(Node root, String tagParent, String tagChild) {
        return XMLUtil.dataSetFromNode(root, tagParent, tagChild, true);
    }

    public static Vector<Object> commaDataSetFromNode(Node root, String tagParent, String tagChild) {
        return XMLUtil.dataSetFromNode(root, tagParent, tagChild, false);
    }

    public static String filterValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String bTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return "<" + tagName + ">";
    }

    public static String eTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return "</" + tagName + ">";
    }

    public static String wrap(String tagName, String value) {
        if (tagName == null) {
            return null;
        }
        return XMLUtil.bTag(tagName) + XMLUtil.filterValue(value) + XMLUtil.eTag(tagName);
    }

    public static String indentWrap(String indent, String tagName, String value) {
        if (tagName == null) {
            return null;
        }
        if (indent == null) {
            indent = "";
        }
        return indent + XMLUtil.wrap(tagName, XMLUtil.filterValue(value));
    }

    public static void printWrap(String indent, String tagName, String value) {
        System.out.println(XMLUtil.indentWrap(indent, tagName, value));
    }

    public static String xmlProperties() {
        return "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?>";
    }

    public static String xmlHeader(String tagName, String attr1, String value1, String attr2, String value2) {
        return "<" + tagName + " " + attr1 + "=\"" + value1 + " " + attr2 + "=\"" + value2 + "\">";
    }
}

