/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MFFFile
extends MFFResource {
    public static final String classID = "MFLE";
    private File mffFile = null;

    public MFFFile() {
    }

    public MFFFile(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public MFFFile copy() throws CloneNotSupportedException {
        return (MFFFile)this.clone();
    }

    public ArrayList<String> getResourceList(boolean fullURI) {
        ArrayList<String> rVal = new ArrayList<String>();
        File file = new File(this.getURI());
        File[] list = file.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (fullURI) {
                    try {
                        rVal.add(list[i].getCanonicalPath());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MFFFile.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                rVal.add(list[i].getName());
            }
        }
        return rVal;
    }

    public ArrayList<String> getSignalResourceList(boolean fullURI) {
        ArrayList<String> rVal = new ArrayList<String>();
        ArrayList<String> resourceList = this.getResourceList(fullURI);
        if (resourceList != null) {
            for (String resource : resourceList) {
                String resourceCheck;
                if (fullURI) {
                    Path p = Paths.get(resource, new String[0]);
                    resourceCheck = p.getFileName().toString();
                } else {
                    resourceCheck = resource;
                }
                if (!resourceCheck.startsWith("signal") || !resourceCheck.endsWith(".bin")) continue;
                rVal.add(resource);
            }
        }
        return rVal;
    }

    public String getCorrespondingInfoNResourceURI(String signalURI) {
        String rVal = "No Matching InfoN";
        if (signalURI != null) {
            String signalFileName = signalURI.substring(signalURI.lastIndexOf("/") + 1);
            if (signalFileName.length() >= 11) {
                String numBuffer = "";
                String strNum = signalFileName.substring(6, signalFileName.lastIndexOf("."));
                for (int i = 0; i < strNum.length() && Character.isDigit(strNum.charAt(i)); ++i) {
                    numBuffer = numBuffer + strNum.charAt(i);
                }
                if (numBuffer.length() < 1) {
                    System.out.println("Error: No Value for Index");
                } else {
                    rVal = this.uri_ + "/info" + numBuffer + ".xml";
                }
            } else {
                System.out.println("Error in signal file name.");
            }
        }
        return rVal;
    }

    int getNumberOfEventTracks() {
        int rVal = -1;
        ArrayList<String> eventTrackList = this.getEventTrackList(false);
        rVal = eventTrackList.size();
        return rVal;
    }

    public ArrayList<String> getEventTrackList(boolean fullURI) {
        ArrayList<String> rVal = new ArrayList<String>();
        ArrayList<String> resourceList = this.getResourceList(fullURI);
        if (resourceList != null) {
            for (String resource : resourceList) {
                String resourceCheck;
                if (fullURI) {
                    Path p = Paths.get(resource, new String[0]);
                    resourceCheck = p.getFileName().toString();
                } else {
                    resourceCheck = resource;
                }
                if (!resourceCheck.startsWith("Events_") || !resourceCheck.endsWith(".xml")) continue;
                rVal.add(resource);
            }
        }
        return rVal;
    }

    private ArrayList<String> fileNamesWithPrefixAndExtension(String filePrefix, String fileExtension) {
        ArrayList<String> files = new ArrayList<String>();
        File[] list = this.mffFile.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String name;
            File file = list[i];
            if (!file.exists() || file.isDirectory() || files.contains(name = file.getName()) || filePrefix != null && !name.startsWith(filePrefix) || fileExtension != null && !name.endsWith(fileExtension)) continue;
            files.add(name);
        }
        return files;
    }

    public String getClassID() {
        return classID;
    }

    public static void main(String[] args) {
        try {
            String uri = "/Users/dborland/Documents/Net Station User Data/Defects/14246 Overlapping segmentation crashes/Subject 1.mff";
            MFFFactory factory = new MFFFactory(new LocalMFFFactoryDelegate());
            MFFResource resource = factory.openResourceAtURI(uri, new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_MFFFile));
            if (resource instanceof MFFFile) {
                MFFFile mffFile = (MFFFile)resource;
                System.out.println("MFFFile: ------");
                System.out.println("MFFFile: number of event tracks: " + mffFile.getNumberOfEventTracks());
                System.out.println("MFFFile: Event Tracks:" + mffFile.getEventTrackList(true));
                System.out.println("MFFFile: ------");
                factory.closeResource(mffFile);
            } else {
                System.out.println("MFFFile: error: unable to open resource: " + uri);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MFFFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

