/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import com.egi.services.mff.test.schema.MFFSchema;
import com.egi.services.mff.utility.MFFRoot;
import com.egi.services.mff.utility.ResourceMarshalException;
import com.egi.services.mff.utility.ResourceUnmarshalException;
import com.egi.services.mff.utility.ResourceValidationException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MFFRootDoc
extends MFFRoot {
    public static final String XmlnsAttr = "xmlns";
    public static final String XmlnsXSIAttr = "xmlns:xsi";
    public static final String XmlnsRoot = "http://www.egi.com/";
    public static final String XmlnsXSI = "http://www.w3.org/2001/XMLSchema-instance";
    private Document document = null;
    private String name = null;
    private String fileName = null;
    private String filePrefix = null;
    private String fileSuffix = null;
    private boolean isLoaded = false;
    public static final String NameTag = "name";

    protected static Document newXMLDocument() throws ResourceMarshalException {
        Document rVal = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            rVal = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException exp) {
            System.out.println("MFFRootDoc: error: " + exp.toString());
            throw new ResourceMarshalException("could not obtain xml engine resources");
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document documentFromMMFXMLFile(String filePath) throws ResourceUnmarshalException {
        block9: {
            this.document = null;
            if (filePath != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    documentBuilderFactory.setValidating(false);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    if (!this.isThreadSafe()) {
                        this.fileName = filePath;
                        this.document = documentBuilder.parse(new File(this.fileName));
                        break block9;
                    }
                    MFFRootDoc mFFRootDoc = this;
                    synchronized (mFFRootDoc) {
                        this.fileName = filePath;
                        this.document = documentBuilder.parse(new File(this.fileName));
                    }
                }
                catch (ParserConfigurationException exp) {
                    System.out.println("MFFRootDoc: error: " + exp.toString());
                    throw new ResourceUnmarshalException("could not obtain xml engine resources");
                }
                catch (SAXException exp) {
                    System.out.println("MFFRootDoc: error: " + exp.toString());
                    throw new ResourceUnmarshalException("could not parse from xml resource");
                }
                catch (IOException exp) {
                    System.out.println("MFFRootDoc: error: " + exp.toString());
                    throw new ResourceUnmarshalException("could not obtain resources");
                }
            }
        }
        return this.document;
    }

    protected Node loadMMFXMLFile(String filePath) throws ResourceUnmarshalException {
        Element root = null;
        Document document = this.documentFromMMFXMLFile(filePath);
        if (document != null && (root = document.getDocumentElement()) != null) {
            root.normalize();
        }
        return root;
    }

    public String saveFilePath(String filePath) {
        String path = filePath != null ? filePath : this.fileName;
        File file = new File(path);
        String root = file.getParent();
        String fNam = this.filePrefix != null ? this.filePrefix : file.getName().split("_")[0].split("\\.")[0];
        String save = root + "/" + fNam + (this.name != null ? "_" + this.name : "") + (this.fileSuffix != null ? "_" + this.fileSuffix : "") + ".xml";
        return save;
    }

    protected void transformMFFXMLDoc(String filePath, String xsdName, Node root) throws ResourceMarshalException, ResourceValidationException {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(root);
            StringWriter sw = new StringWriter();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("encoding", "iso-8859-1");
            trans.setOutputProperty("standalone", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            trans.setOutputProperty("indent", "yes");
            trans.transform(source, new StreamResult(sw));
            FileWriter xmlWriter = new FileWriter(filePath);
            String xmlString = sw.toString().trim();
            xmlWriter.write(xmlString);
            xmlWriter.close();
            if (xsdName != null) {
                this.validateDOMSource(source, xsdName);
            }
        }
        catch (TransformerConfigurationException exp) {
            throw new ResourceMarshalException("could not obtain xml engine resources");
        }
        catch (TransformerException exp) {
            throw new ResourceMarshalException("could transform to xml resource");
        }
        catch (IOException exp) {
            throw new ResourceMarshalException("could not obtain resources");
        }
    }

    private void validateDOMSource(DOMSource domSource, String xsdName) throws ResourceValidationException {
        if (xsdName == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                InputStream xsdStream = new MFFSchema().xsdForFile(xsdName);
                Schema schema = schemaFactory.newSchema(new StreamSource(xsdStream));
                Validator validator = schema.newValidator();
                validator.validate(domSource);
            }
            catch (SAXException exp) {
                throw new ResourceValidationException("could not validate XSD file \"res/schema/" + xsdName);
            }
            catch (NullPointerException exp) {
                throw new ResourceValidationException("could not obtain xml validation resources");
            }
            catch (IOException exp) {
                throw new ResourceValidationException("could not obtain resource");
            }
        } else {
            throw new ResourceValidationException("could not obtain schema resource: " + xsdName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilePrefix(String value) {
        if (!this.isThreadSafe()) {
            this.filePrefix = value;
        } else {
            MFFRootDoc mFFRootDoc = this;
            synchronized (mFFRootDoc) {
                this.filePrefix = value;
            }
        }
    }

    public String filePrefix() {
        return this.filePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String value) {
        if (!this.isThreadSafe()) {
            this.name = value;
        } else {
            MFFRootDoc mFFRootDoc = this;
            synchronized (mFFRootDoc) {
                this.name = value;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileSuffix(String value) {
        this.fileSuffix = value;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public Document document() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasLoadedFile(boolean value) {
        if (!this.isThreadSafe()) {
            this.isLoaded = value;
        } else {
            MFFRootDoc mFFRootDoc = this;
            synchronized (mFFRootDoc) {
                this.isLoaded = value;
            }
        }
    }

    public boolean hasLoadedFile() {
        return this.isLoaded;
    }
}

