/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.CraniumNormals;
import com.egi.services.mff.api.Dipole;
import com.egi.services.mff.api.DipoleSet;
import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import com.egi.services.mff.api.SensorLayout;
import com.egi.services.mff.api.SubjectInfo;
import com.egi.services.mff.api.TriangleSurface;
import com.egi.services.mff.utility.XMLUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeometryEGIG
extends MFFResource {
    public static final String classID = "GEIG";
    protected ArrayList<String> history_ = null;
    protected SubjectInfo subjectInfo_ = null;
    protected CraniumNormals craniumNormals_ = null;
    protected SensorLayout sensorLayout_ = null;
    protected DipoleSet dipoleSet_ = null;
    protected ArrayList<TriangleSurface> triangleSurfaces_ = null;

    public GeometryEGIG() {
    }

    public GeometryEGIG(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public GeometryEGIG copy() throws CloneNotSupportedException {
        return (GeometryEGIG)this.clone();
    }

    public void setHistory(ArrayList<String> history) {
        this.history_ = history;
    }

    public ArrayList<String> getHistory() {
        return this.history_;
    }

    public void setSubjectInfo(SubjectInfo subjectInfo) {
        this.subjectInfo_ = subjectInfo;
    }

    public SubjectInfo getSubjectInfo() {
        return this.subjectInfo_;
    }

    public void setCraniumNormals(CraniumNormals craniumNormals) {
        this.craniumNormals_ = craniumNormals;
    }

    public CraniumNormals getCraniumNormals() {
        return this.craniumNormals_;
    }

    public void setSensorLayout(SensorLayout sensorLayout) {
        this.sensorLayout_ = sensorLayout;
    }

    public SensorLayout getSensorLayout() {
        return this.sensorLayout_;
    }

    public void setDipoleSet(DipoleSet dipoleSet) {
        this.dipoleSet_ = dipoleSet;
    }

    public DipoleSet getDipoleSet() {
        return this.dipoleSet_;
    }

    public void setTriangleSurfaces(ArrayList<TriangleSurface> triangleSurfaces) {
        this.triangleSurfaces_ = triangleSurfaces;
    }

    public ArrayList<TriangleSurface> getTriangleSurfaces() {
        return this.triangleSurfaces_;
    }

    public String getClassID() {
        return classID;
    }

    public static void main(String[] args) {
        try {
            String uri = "/Users/bertie/Desktop/00mip_Test64_256_oriented/geometry.egig";
            MFFFactory factory = new MFFFactory(new LocalMFFFactoryDelegate());
            MFFResource resource = factory.openResourceAtURI(uri, new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_GeometryEGIG));
            if (resource instanceof GeometryEGIG) {
                GeometryEGIG geometryEGIG = (GeometryEGIG)resource;
                if (geometryEGIG.loadResource()) {
                    ArrayList<Dipole> dipoles;
                    System.out.println("geometryEGIG unit test: history:");
                    System.out.println("geometryEGIG unit test: ------");
                    ArrayList<String> history = geometryEGIG.getHistory();
                    if (history != null) {
                        System.out.println("geometryEGIG unit test: number of history entries: " + history.size());
                        for (String historyEvent : history) {
                            System.out.println("geometryEGIG unit test:   history event: " + historyEvent);
                        }
                    }
                    System.out.println("geometryEGIG unit test: ------");
                    CraniumNormals craniumNormals = geometryEGIG.getCraniumNormals();
                    if (craniumNormals != null && craniumNormals.getPointsDataType() == XMLUtil.DataTypes.FLOAT) {
                        float[] craniumNormalsPointsdata = (float[])craniumNormals.getPointsData();
                        System.out.print("geometryEGIG unit test: points data: ");
                        for (int i = 0; i < craniumNormalsPointsdata.length; ++i) {
                            System.out.print(craniumNormalsPointsdata[i] + " ");
                        }
                        System.out.println("");
                    }
                    System.out.println("geometryEGIG unit test: ------");
                    DipoleSet dipoleSet = geometryEGIG.getDipoleSet();
                    if (dipoleSet != null && (dipoles = dipoleSet.getDipoles()) != null) {
                        for (Dipole dipole : dipoles) {
                            System.out.print("geometryEGIG unit test: dipole ids: ");
                            System.out.print(dipole.getID() + " ");
                            System.out.println("");
                        }
                    }
                    System.out.println("geometryEGIG unit test: ------");
                } else {
                    System.out.println("geometryEGIG: error: unable to load resource: " + uri);
                }
                factory.closeResource(geometryEGIG);
            } else {
                System.out.println("geometryEGIG: error: unable to open resource: " + uri);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(GeometryEGIG.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

