/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.BulkTableScanResultSet;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.InsertConstantAction;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RIBulkChecker;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.ValueRow;

class InsertResultSet
extends DMLWriteResultSet
implements TargetResultSet {
    private NoPutResultSet sourceResultSet;
    NoPutResultSet savedSource;
    InsertConstantAction constants;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private long heapConglom;
    private ResultSet autoGeneratedKeysResultSet;
    private TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    private ResultDescription resultDescription;
    private RowChanger rowChanger;
    private TransactionController tc;
    private ExecRow row;
    boolean userSpecifiedBulkInsert;
    boolean bulkInsertPerformed;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private boolean firstRow = true;
    private boolean[] needToDropSort;
    private Hashtable indexConversionTable;
    private FormatableBitSet indexedCols;
    private ConglomerateController bulkHeapCC;
    protected DataDictionary dd;
    protected TableDescriptor td;
    private ExecIndexRow[] indexRows;
    private ExecRow fullTemplate;
    private long[] sortIds;
    private RowLocationRetRowSource[] rowSources;
    private ScanController bulkHeapSC;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private SortController[] sorters;
    private TemporaryRowHolderImpl rowHolder;
    private RowLocation rl;
    private boolean hasBeforeStatementTrigger;
    private boolean hasBeforeRowTrigger;
    private BulkTableScanResultSet tableScan;
    private int numOpens;
    private boolean firstExecute;
    private FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private NumberDataValue[] aiCache;
    protected boolean autoincrementGenerated;
    private long identityVal;
    private boolean setIdentity;

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void changedRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.constants.irgs.length > 0) {
            int n;
            RowLocation rowLocation2 = (RowLocation)rowLocation.cloneValue(false);
            for (n = 0; n < execRow.getRowArray().length; ++n) {
                if (!this.constants.indexedCols[n] || !(execRow.getRowArray()[n] instanceof StreamStorable)) continue;
                execRow.getRowArray()[n].getObject();
            }
            if (this.firstRow) {
                this.firstRow = false;
                this.indexRows = new ExecIndexRow[this.constants.irgs.length];
                this.setUpAllSorts(execRow.getNewNullRow(), rowLocation2);
            }
            for (n = 0; n < this.constants.irgs.length; ++n) {
                this.indexRows[n].getNewObjectArray();
                this.constants.irgs[n].getIndexRow(execRow, rowLocation2, this.indexRows[n], null);
                this.sorters[n].insert(this.indexRows[n].getRowArray());
            }
        }
    }

    public ExecRow preprocessSourceRow(ExecRow execRow) throws StandardException {
        if (this.hasBeforeRowTrigger) {
            this.rowHolder.truncate();
            this.rowHolder.insert(execRow);
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
        }
        if (this.generationClauses != null) {
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, execRow, false);
        }
        if (this.checkGM != null && !this.hasBeforeStatementTrigger) {
            this.evaluateCheckConstraints();
        }
        if (this.constants.irgs.length > 0) {
            return execRow.getClone(this.indexedCols);
        }
        return execRow;
    }

    private void evaluateCheckConstraints() throws StandardException {
        if (this.checkGM != null) {
            this.checkGM.invoke(this.activation);
        }
    }

    InsertResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = noPutResultSet;
        this.constants = (InsertConstantAction)this.constantAction;
        this.generationClauses = generatedMethod;
        this.checkGM = generatedMethod2;
        this.heapConglom = this.constants.conglomId;
        this.tc = activation.getTransactionController();
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.hasBeforeStatementTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, false) : false;
        this.hasBeforeRowTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, true) : false;
        this.resultDescription = this.sourceResultSet.getResultDescription();
        String string = this.constants.getProperty("insertMode");
        RowLocation[] rowLocationArray = this.constants.getAutoincRowLocation();
        if (rowLocationArray != null) {
            this.aiCache = new NumberDataValue[rowLocationArray.length];
            for (int i = 0; i < this.resultDescription.getColumnCount(); ++i) {
                if (rowLocationArray[i] == null) continue;
                ResultColumnDescriptor resultColumnDescriptor = this.resultDescription.getColumnDescriptor(i + 1);
                this.aiCache[i] = (NumberDataValue)resultColumnDescriptor.getType().getNull();
            }
        }
        if (string != null) {
            if (StringUtil.SQLEqualsIgnoreCase(string, "BULKINSERT")) {
                this.userSpecifiedBulkInsert = true;
            } else if (StringUtil.SQLEqualsIgnoreCase(string, "REPLACE")) {
                this.userSpecifiedBulkInsert = true;
                this.bulkInsertReplace = true;
                this.bulkInsert = true;
                if (this.triggerInfo != null) {
                    TriggerDescriptor triggerDescriptor = this.triggerInfo.getTriggerArray()[0];
                    throw StandardException.newException("X0Y72.S", (Object)this.constants.getTableName(), (Object)triggerDescriptor.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws StandardException {
        this.setup();
        this.firstExecute = this.rowChanger == null;
        this.autoincrementGenerated = false;
        this.dd = this.lcc.getDataDictionary();
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            if (this.activation.getAutoGeneratedKeysColumnIndexes() != null) {
                this.verifyAutoGeneratedColumnsIndexes(this.activation.getAutoGeneratedKeysColumnIndexes());
            } else if (this.activation.getAutoGeneratedKeysColumnNames() != null) {
                this.verifyAutoGeneratedColumnsNames(this.activation.getAutoGeneratedKeysColumnNames());
            }
        }
        this.rowCount = 0;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        if (this.userSpecifiedBulkInsert) {
            if (!this.bulkInsertReplace) {
                this.bulkInsert = this.verifyBulkInsert();
            } else {
                this.getExclusiveTableLock();
            }
        }
        if (this.bulkInsert) {
            this.sourceResultSet.setTargetResultSet(this);
            long l = this.bulkInsertCore(this.lcc, this.heapConglom);
            if (this.hasBeforeStatementTrigger) {
                this.tableScan = this.getTableScanResultSet(l);
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.tableScan);
                if (this.checkGM != null || this.generationClauses != null) {
                    this.tableScan = this.getTableScanResultSet(l);
                    try {
                        ExecRow execRow = null;
                        while ((execRow = this.tableScan.getNextRowCore()) != null) {
                            this.sourceResultSet.setCurrentRow(execRow);
                            this.evaluateCheckConstraints();
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.sourceResultSet.clearCurrentRow();
                        throw throwable;
                    }
                    this.sourceResultSet.clearCurrentRow();
                    {
                    }
                }
            }
            this.bulkValidateForeignKeys(this.tc, this.lcc.getContextManager());
            if (this.triggerInfo != null && (this.triggerInfo.hasTrigger(false, true) || this.triggerInfo.hasTrigger(false, false))) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.getTableScanResultSet(l));
            }
            this.bulkInsertPerformed = true;
        } else {
            this.row = this.getNextRowCore(this.sourceResultSet);
            this.normalInsertCore(this.lcc, this.firstExecute);
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
        this.cleanUp();
        if (this.aiCache != null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            int n = this.aiCache.length;
            for (int i = 0; i < n; ++i) {
                if (this.aiCache[i] == null) continue;
                hashMap.put(AutoincrementCounter.makeIdentity(this.constants.getSchemaName(), this.constants.getTableName(), this.constants.getColumnName(i)), new Long(this.aiCache[i].getLong()));
            }
            InternalTriggerExecutionContext internalTriggerExecutionContext = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (internalTriggerExecutionContext == null) {
                this.lcc.copyHashtableToAIHT(hashMap);
            } else {
                internalTriggerExecutionContext.copyHashtableToAIHT(hashMap);
            }
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    public void close() throws StandardException {
        super.close();
        if (this.autoGeneratedKeysRowsHolder != null) {
            this.autoGeneratedKeysRowsHolder.close();
        }
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] nArray) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i]);
            if (this.verifyAutoGenColumn(columnDescriptor)) continue;
            throw StandardException.newException("X0X0E.S", (Object)new Integer(nArray[i]), (Object)tableDescriptor.getName());
        }
    }

    private int[] generatedColumnPositionsArray() throws StandardException {
        int n;
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int n2 = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < n2; ++n) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n + 1);
            if (columnDescriptor.isAutoincrement()) {
                ++n3;
                nArray[n] = n + 1;
                continue;
            }
            if (columnDescriptor.getDefaultValue() == null && columnDescriptor.getDefaultInfo() == null) continue;
            ++n3;
            nArray[n] = n + 1;
        }
        int[] nArray2 = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[n4++] = nArray[i];
        }
        return nArray2;
    }

    private int[] uniqueColumnPositionArray(int[] nArray) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int[] nArray2 = new int[tableDescriptor.getMaxColumnID()];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray2[nArray[i] - 1] != 0) continue;
            ++n2;
            nArray2[nArray[i] - 1] = nArray[i];
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            nArray3[n3++] = nArray2[i];
        }
        return nArray3;
    }

    private void verifyAutoGeneratedColumnsNames(String[] stringArray) throws StandardException {
        int n = stringArray.length;
        int[] nArray = new int[n];
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) {
                throw StandardException.newException("X0X0F.S", (Object)stringArray[i], (Object)tableDescriptor.getName());
            }
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
            if (!this.verifyAutoGenColumn(columnDescriptor)) {
                throw StandardException.newException("X0X0F.S", (Object)stringArray[i], (Object)tableDescriptor.getName());
            }
            nArray[i] = columnDescriptor.getPosition();
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(nArray, null);
    }

    private boolean verifyAutoGenColumn(ColumnDescriptor columnDescriptor) {
        return columnDescriptor != null && columnDescriptor.isAutoincrement();
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumberDataValue getSetAutoincrementValue(int n, long l) throws StandardException {
        NumberDataValue numberDataValue;
        int n2;
        block13: {
            long l2 = 0L;
            n2 = n - 1;
            this.setIdentity = !this.autoincrementGenerated && this.isSourceRowResultSet();
            this.autoincrementGenerated = true;
            if (this.bulkInsert) {
                ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(n);
                if (this.aiCache[n2].isNull()) {
                    if (this.bulkInsertReplace) {
                        l2 = columnDescriptor.getAutoincStart();
                    } else {
                        NumberDataValue numberDataValue2 = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], this.tc, false, this.aiCache[n2], true);
                        l2 = numberDataValue2.getLong();
                    }
                    this.lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName(), new Long(l2), l, n);
                }
                long l3 = this.lcc.nextAutoincrementValue(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName());
                this.aiCache[n - 1].setValue(l3);
                return this.aiCache[n2];
            }
            TransactionController transactionController = null;
            TransactionController transactionController2 = this.tc;
            try {
                transactionController2 = transactionController = this.tc.startNestedUserTransaction(false);
            }
            catch (StandardException standardException) {
                transactionController2 = this.tc;
            }
            try {
                try {
                    numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], transactionController2, true, this.aiCache[n2], transactionController2 == this.tc);
                }
                catch (StandardException standardException) {
                    if (transactionController2 == this.tc) {
                        throw standardException;
                    }
                    if (!standardException.getMessageId().equals("40XL1")) {
                        if (!standardException.getMessageId().equals("22003")) throw standardException;
                        throw StandardException.newException("42Z24", standardException, (Object)this.constants.getTableName(), (Object)this.constants.getColumnName(n2));
                    }
                    numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n2], this.tc, true, this.aiCache[n2], true);
                    Object var13_14 = null;
                    if (transactionController != null) {
                        transactionController.commit();
                        transactionController.destroy();
                    }
                    break block13;
                }
                Object var13_13 = null;
                if (transactionController == null) break block13;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (transactionController == null) throw throwable;
                transactionController.commit();
                transactionController.destroy();
                throw throwable;
            }
            transactionController.commit();
            transactionController.destroy();
        }
        this.aiCache[n2] = numberDataValue;
        if (!this.setIdentity) return this.aiCache[n2];
        this.identityVal = numberDataValue.getLong();
        return this.aiCache[n2];
    }

    private boolean isSourceRowResultSet() {
        boolean bl = false;
        if (this.sourceResultSet instanceof NormalizeResultSet) {
            bl = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return bl;
    }

    private boolean isSingleRowResultSet() {
        boolean bl = false;
        if (this.sourceResultSet instanceof RowResultSet) {
            bl = true;
        } else if (this.sourceResultSet instanceof NormalizeResultSet) {
            bl = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalInsertCore(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = this.constants.hasAutoincrement() && this.isSingleRowResultSet();
        boolean bl3 = true;
        ExecRow execRow = null;
        long l = 0L;
        if (bl) {
            this.rowChanger = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, 0, this.tc, null, this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        }
        int n = this.decodeLockMode(this.constants.lockMode);
        this.rowChanger.open(n);
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
        if (bl && this.constants.deferred) {
            object3 = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet((Properties)object3);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, (Properties)object3, this.resultDescription);
            this.rowChanger.setRowHolder(this.rowHolder);
        }
        object3 = null;
        if (bl && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            object3 = this.activation.getAutoGeneratedKeysColumnIndexes();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            object3 = object3 != null ? (Object)this.uniqueColumnPositionArray((int[])object3) : (Object)this.generatedColumnPositionsArray();
            object2 = languageConnectionContext.getLanguageFactory().getResultDescription(this.resultDescription, (int[])object3);
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.activation, properties, (ResultDescription)object2);
        }
        while (this.row != null) {
            if (this.activation.getAutoGeneratedKeysResultsetMode()) {
                this.autoGeneratedKeysRowsHolder.insert(this.getCompactRow(this.row, (int[])object3));
            }
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, this.row, false);
            if (this.constants.deferred) {
                this.rowHolder.insert(this.row);
            } else {
                this.evaluateCheckConstraints();
                if (this.fkChecker != null) {
                    this.fkChecker.doFKCheck(this.row);
                }
                if (this.constants.irgs.length > 0) {
                    object2 = this.row.getRowArray();
                    for (int i = 0; i < ((DataValueDescriptor[])object2).length; ++i) {
                        if (!this.constants.indexedCols[i] || !(object2[i] instanceof StreamStorable)) continue;
                        object2[i].getObject();
                    }
                }
                this.rowChanger.insertRow(this.row);
            }
            ++this.rowCount;
            if (bl2) {
                int n2;
                this.dd = languageConnectionContext.getDataDictionary();
                this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
                int n3 = this.td.getMaxColumnID();
                for (n2 = 1; n2 <= n3 && !((ColumnDescriptor)(object = this.td.getColumnDescriptor(n2))).isAutoincrement(); ++n2) {
                }
                if (n2 <= n3) {
                    object = this.row.cloneColumn(n2);
                    l = object.getLong();
                }
            }
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            if (this.triggerInfo != null) {
                object2 = null;
                if (this.aiCache != null) {
                    object2 = new Vector();
                    for (int i = 0; i < this.aiCache.length; ++i) {
                        if (this.aiCache[i] == null) continue;
                        object = this.constants.getSchemaName();
                        String string = this.constants.getTableName();
                        String string2 = this.constants.getColumnName(i);
                        Long l2 = languageConnectionContext.lastAutoincrementValue((String)object, string, string2);
                        AutoincrementCounter autoincrementCounter = new AutoincrementCounter(l2, this.constants.getAutoincIncrement(i), this.aiCache[i].getLong(), (String)object, string, string2, i + 1);
                        ((Vector)object2).addElement(autoincrementCounter);
                    }
                }
                if (this.triggerActivator == null) {
                    this.triggerActivator = new TriggerEventActivator(languageConnectionContext, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, (Vector)object2);
                } else {
                    this.triggerActivator.reopen();
                }
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet());
            }
            object2 = this.rowHolder.getResultSet();
            try {
                object2.open();
                while ((execRow = object2.getNextRow()) != null) {
                    this.sourceResultSet.setCurrentRow(execRow);
                    this.evaluateCheckConstraints();
                    this.rowChanger.insertRow(execRow);
                }
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                this.sourceResultSet.clearCurrentRow();
                object2.close();
                throw throwable;
            }
            this.sourceResultSet.clearCurrentRow();
            object2.close();
            if (this.fkChecker != null) {
                object2 = this.rowHolder.getResultSet();
                try {
                    object2.open();
                    while ((execRow = object2.getNextRow()) != null) {
                        this.fkChecker.doFKCheck(execRow);
                    }
                    Object var20_23 = null;
                }
                catch (Throwable throwable) {
                    Object var20_24 = null;
                    object2.close();
                    throw throwable;
                }
                object2.close();
                {
                }
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.rowHolder.getResultSet());
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
            this.fkChecker = null;
        }
        if (this.setIdentity) {
            languageConnectionContext.setIdentityValue(this.identityVal);
        } else if (bl2) {
            languageConnectionContext.setIdentityValue(l);
        }
    }

    private ExecRow getCompactRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n = execRow.nColumns();
        if (nArray == null) {
            ValueRow valueRow = new ValueRow(n);
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            DataValueDescriptor[] dataValueDescriptorArray2 = valueRow.getRowArray();
            System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
            return valueRow;
        }
        int n2 = nArray.length;
        ValueRow valueRow = new ValueRow(n2);
        for (int i = 0; i < n2; ++i) {
            valueRow.setColumn(i + 1, execRow.getColumn(nArray[i]));
        }
        return valueRow;
    }

    private long bulkInsertCore(LanguageConnectionContext languageConnectionContext, long l) throws StandardException {
        Object object;
        this.fullTemplate = this.constants.getEmptyHeapRow(languageConnectionContext);
        this.bulkHeapCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, this.constants.heapSCOCI, this.heapDCOCI);
        Properties properties = new Properties();
        this.bulkHeapCC.getInternalTablePropertySet(properties);
        if (this.triggerInfo != null) {
            this.triggerActivator = new TriggerEventActivator(languageConnectionContext, this.tc, this.constants.targetUUID, this.triggerInfo, 3, this.activation, null);
        }
        if (this.hasBeforeRowTrigger && this.rowHolder != null) {
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription);
        }
        Properties properties2 = this.constants.getTargetProperties();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            properties.put(object, properties2.getProperty((String)object));
        }
        if (this.constants.irgs.length > 0) {
            this.sourceResultSet.setNeedsRowLocation(true);
        }
        this.dd = languageConnectionContext.getDataDictionary();
        this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
        object = new long[1];
        long l2 = this.bulkInsertReplace ? this.tc.createAndLoadConglomerate("heap", this.fullTemplate.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, this.sourceResultSet, (long[])object) : this.tc.recreateAndLoadConglomerate("heap", false, this.fullTemplate.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, l, this.sourceResultSet, (long[])object);
        if (l2 == l) {
            return l;
        }
        this.rowCount = (int)object[0];
        this.setEstimatedRowCount(l2);
        this.dd.startWriting(languageConnectionContext);
        languageConnectionContext.autoincrementFlushCache(this.constants.targetUUID);
        DependencyManager dependencyManager = this.dd.getDependencyManager();
        dependencyManager.invalidateFor(this.td, 15, languageConnectionContext);
        if (this.constants.irgs.length > 0) {
            this.updateAllIndexes(l2, this.constants, this.td, this.dd, this.fullTemplate);
        }
        this.bulkHeapCC.close();
        this.bulkHeapCC = null;
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l2, this.tc);
        this.tc.dropConglomerate(l);
        return l2;
    }

    private void bulkValidateForeignKeys(TransactionController transactionController, ContextManager contextManager) throws StandardException {
        if (this.indexRows == null && !this.bulkInsertReplace || this.fkInfoArray == null) {
            return;
        }
        for (int i = 0; i < this.fkInfoArray.length; ++i) {
            FKInfo fKInfo = this.fkInfoArray[i];
            if (this.bulkInsertReplace) {
                for (int j = 0; j < fKInfo.fkConglomNumbers.length; ++j) {
                    long l;
                    long l2;
                    if (fKInfo.fkIsSelfReferencing[j] && this.indexRows == null) continue;
                    if (fKInfo.fkIsSelfReferencing[j]) {
                        l2 = (Long)this.indexConversionTable.get(new Long(fKInfo.refConglomNumber));
                        l = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[j]));
                    } else {
                        Long l3 = (Long)this.indexConversionTable.get(new Long(fKInfo.refConglomNumber));
                        Long l4 = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[j]));
                        l2 = l3 == null ? fKInfo.refConglomNumber : l3;
                        l = l4 == null ? fKInfo.fkConglomNumbers[j] : l4;
                    }
                    this.bulkValidateForeignKeysCore(transactionController, contextManager, this.fkInfoArray[i], l, l2, fKInfo.fkConstraintNames[j]);
                }
                continue;
            }
            Long l = (Long)this.indexConversionTable.get(new Long(fKInfo.fkConglomNumbers[0]));
            this.bulkValidateForeignKeysCore(transactionController, contextManager, this.fkInfoArray[i], l, fKInfo.refConglomNumber, fKInfo.fkConstraintNames[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkValidateForeignKeysCore(TransactionController transactionController, ContextManager contextManager, FKInfo fKInfo, long l, long l2, String string) throws StandardException {
        GenericScanController genericScanController;
        block6: {
            genericScanController = null;
            GenericScanController genericScanController2 = null;
            try {
                ExecRow execRow = this.makeIndexTemplate(fKInfo, this.fullTemplate, contextManager);
                genericScanController2 = transactionController.openGroupFetchScan(l, false, 0, 7, 2, null, null, 1, null, null, -1);
                genericScanController = transactionController.openGroupFetchScan(l2, false, 0, l == l2 ? 7 : 6, 2, null, null, 1, null, null, -1);
                ExecRow execRow2 = execRow.getClone();
                RIBulkChecker rIBulkChecker = new RIBulkChecker((GroupFetchScanController)genericScanController, (GroupFetchScanController)genericScanController2, execRow, true, null, execRow2);
                int n = rIBulkChecker.doCheck();
                if (n > 0) {
                    StandardException standardException = StandardException.newException("23503", string, (Object)fKInfo.tableName, (Object)StatementUtil.typeName(fKInfo.stmtType), (Object)RowUtil.toString(execRow2, 0, fKInfo.colArray.length - 1));
                    throw standardException;
                }
                Object var17_14 = null;
                if (genericScanController2 == null) break block6;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                if (genericScanController2 != null) {
                    genericScanController2.close();
                    genericScanController2 = null;
                }
                if (genericScanController != null) {
                    genericScanController.close();
                    genericScanController = null;
                }
                throw throwable;
            }
            genericScanController2.close();
            genericScanController2 = null;
        }
        if (genericScanController != null) {
            genericScanController.close();
            genericScanController = null;
        }
    }

    private ExecRow makeIndexTemplate(FKInfo fKInfo, ExecRow execRow, ContextManager contextManager) throws StandardException {
        ExecIndexRow execIndexRow = RowUtil.getEmptyIndexRow(fKInfo.colArray.length + 1, this.lcc);
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow.getRowArray();
        for (int i = 0; i < fKInfo.colArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[fKInfo.colArray[i] - 1].cloneValue(false);
        }
        dataValueDescriptorArray2[i] = fKInfo.rowLocation.cloneValue(false);
        return execIndexRow;
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n;
        int n2 = this.constants.irgs.length;
        int n3 = this.td.getNumberOfColumns();
        this.ordering = new ColumnOrdering[n2][];
        this.collation = new int[n2][];
        this.needToDropSort = new boolean[n2];
        this.sortIds = new long[n2];
        this.rowSources = new RowLocationRetRowSource[n2];
        this.indexedCols = new FormatableBitSet(n3 + 1);
        for (n = 0; n < n2; ++n) {
            int n4;
            boolean bl;
            int[] nArray = this.constants.irgs[n].baseColumnPositions();
            for (int i = 0; i < nArray.length; ++i) {
                this.indexedCols.set(nArray[i]);
            }
            this.indexRows[n] = this.constants.irgs[n].getIndexRowTemplate();
            this.constants.irgs[n].getIndexRow(execRow, rowLocation, this.indexRows[n], null);
            ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.constants.indexCIDS[n]);
            int[] nArray2 = this.constants.irgs[n].baseColumnPositions();
            boolean[] blArray = this.constants.irgs[n].isAscending();
            BasicSortObserver basicSortObserver = null;
            boolean bl2 = bl = n2 == 1;
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                n4 = nArray2.length;
                String[] stringArray = this.getColumnNames(nArray2);
                String string = conglomerateDescriptor.getConglomerateName();
                if (conglomerateDescriptor.isConstraint()) {
                    ConstraintDescriptor constraintDescriptor = this.dd.getConstraintDescriptor(this.td, conglomerateDescriptor.getUUID());
                    string = constraintDescriptor.getConstraintName();
                }
                basicSortObserver = new UniqueIndexSortObserver(false, conglomerateDescriptor.isConstraint(), string, this.indexRows[n], bl, this.td.getName());
            } else {
                n4 = nArray2.length + 1;
                basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n], bl);
            }
            this.ordering[n] = new ColumnOrdering[n4];
            for (int i = 0; i < blArray.length; ++i) {
                this.ordering[n][i] = new IndexColumnOrder(i, blArray[i]);
            }
            if (n4 > blArray.length) {
                this.ordering[n][blArray.length] = new IndexColumnOrder(blArray.length);
            }
            this.collation[n] = this.constants.irgs[n].getColumnCollationIds(this.td.getColumnDescriptorList());
            this.sortIds[n] = this.tc.createSort(null, this.indexRows[n].getRowArrayClone(), this.ordering[n], basicSortObserver, false, (int)this.sourceResultSet.getEstimatedRowCount(), -1);
            this.needToDropSort[n] = true;
        }
        this.sorters = new SortController[n2];
        for (n = 0; n < n2; ++n) {
            this.sorters[n] = this.tc.openSort(this.sortIds[n]);
            this.needToDropSort[n] = true;
        }
    }

    private void updateAllIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        int n = insertConstantAction.irgs.length;
        if (this.indexRows == null) {
            if (this.bulkInsertReplace) {
                this.emptyIndexes(l, insertConstantAction, tableDescriptor, dataDictionary, execRow);
            }
            return;
        }
        dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), null, this.tc);
        long[] lArray = new long[n];
        this.indexConversionTable = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            Properties properties = new Properties();
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[i]);
            ConglomerateController conglomerateController = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[i], this.indexDCOCIs[i]);
            conglomerateController.getInternalTablePropertySet(properties);
            int n2 = this.indexRows[i].nColumns();
            properties.put("baseConglomerateId", Long.toString(l));
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(n2 - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(n2));
            }
            if (conglomerateDescriptor.getIndexDescriptor().isUniqueWithDuplicateNulls()) {
                properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            }
            properties.put("rowLocationColumn", Integer.toString(n2 - 1));
            properties.put("nKeyFields", Integer.toString(n2));
            conglomerateController.close();
            this.sorters[i].completedInserts();
            this.sorters[i] = null;
            this.rowSources[i] = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[i]));
            lArray[i] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[i].getRowArray(), this.ordering[i], this.collation[i], properties, 0, this.rowSources[i], null);
            CardinalityCounter cardinalityCounter = (CardinalityCounter)this.rowSources[i];
            long l2 = cardinalityCounter.getRowCount();
            if (l2 > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
                for (int j = 0; j < lArray2.length; ++j) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, lArray2[j]), j + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                }
            }
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[i]), lArray[i], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[i]);
            this.indexConversionTable.put(new Long(insertConstantAction.indexCIDS[i]), new Long(lArray[i]));
        }
    }

    public void cleanUp() throws StandardException {
        int n;
        if (this.tableScan != null) {
            this.tableScan.close();
            this.tableScan = null;
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        this.numOpens = 0;
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.bulkHeapCC != null) {
            this.bulkHeapCC.close();
            this.bulkHeapCC = null;
        }
        if (this.bulkHeapSC != null) {
            this.bulkHeapSC.close();
            this.bulkHeapSC = null;
        }
        if (this.sorters != null) {
            for (n = 0; n < this.constants.irgs.length; ++n) {
                if (this.sorters[n] != null) {
                    this.sorters[n].completedInserts();
                }
                this.sorters[n] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (n = 0; n < this.needToDropSort.length; ++n) {
                if (!this.needToDropSort[n]) continue;
                this.tc.dropSort(this.sortIds[n]);
                this.needToDropSort[n] = false;
            }
        }
        if (this.rowSources != null) {
            for (n = 0; n < this.rowSources.length; ++n) {
                if (this.rowSources[n] == null) continue;
                this.rowSources[n].closeRowSource();
                this.rowSources[n] = null;
            }
        }
        super.close();
    }

    protected boolean verifyBulkInsert() throws StandardException {
        if (this.constants.deferred) {
            return false;
        }
        return this.getExclusiveTableLock();
    }

    private boolean getExclusiveTableLock() throws StandardException {
        boolean bl = false;
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        if (!this.bulkInsertReplace) {
            bl = this.bulkHeapSC.next();
        } else {
            this.rl = this.bulkHeapSC.newRowLocationTemplate();
        }
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
        return !bl;
    }

    private void setEstimatedRowCount(long l) throws StandardException {
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        this.bulkHeapSC.setEstimatedRowCount(this.rowCount);
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
    }

    private void emptyIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        int n;
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4 = insertConstantAction.irgs.length;
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n4];
        ExecRow execRow2 = null;
        ColumnOrdering[][] columnOrderingArrayArray = new ColumnOrdering[n4][];
        int n5 = tableDescriptor.getNumberOfColumns();
        this.collation = new int[n4][];
        FormatableBitSet formatableBitSet = new FormatableBitSet(n5 + 1);
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            int[] nArray = insertConstantAction.irgs[n3].baseColumnPositions();
            for (int i = 0; i < nArray.length; ++i) {
                if (formatableBitSet.get(nArray[i])) continue;
                formatableBitSet.set(nArray[i]);
                ++n6;
            }
        }
        execRow2 = this.activation.getExecutionFactory().getValueRow(n6);
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if (!formatableBitSet.get(n2 + 1)) continue;
            execRow2.setColumn(++n3, execRow.getColumn(n2 + 1).cloneValue(false));
        }
        this.needToDropSort = new boolean[n4];
        this.sortIds = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            execIndexRowArray[n2] = insertConstantAction.irgs[n2].getIndexRowTemplate();
            insertConstantAction.irgs[n2].getIndexRow(execRow2, this.rl, execIndexRowArray[n2], formatableBitSet);
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[n2]);
            int[] nArray = insertConstantAction.irgs[n2].baseColumnPositions();
            object2 = insertConstantAction.irgs[n2].isAscending();
            object = null;
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                n7 = nArray.length;
                String[] stringArray = this.getColumnNames(nArray);
                String string = conglomerateDescriptor.getConglomerateName();
                if (conglomerateDescriptor.isConstraint()) {
                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                    string = constraintDescriptor.getConstraintName();
                }
                object = new UniqueIndexSortObserver(false, conglomerateDescriptor.isConstraint(), string, execIndexRowArray[n2], true, tableDescriptor.getName());
            } else {
                n7 = nArray.length + 1;
                object = new BasicSortObserver(false, false, execIndexRowArray[n2], true);
            }
            columnOrderingArrayArray[n2] = new ColumnOrdering[n7];
            for (n = 0; n < ((Object)object2).length; ++n) {
                columnOrderingArrayArray[n2][n] = new IndexColumnOrder(n, (boolean)object2[n]);
            }
            if (n7 > ((Object)object2).length) {
                columnOrderingArrayArray[n2][((Object)object2).length] = new IndexColumnOrder(((Object)object2).length);
            }
            this.sortIds[n2] = this.tc.createSort(null, execIndexRowArray[n2].getRowArrayClone(), columnOrderingArrayArray[n2], (SortObserver)object, false, this.rowCount, -1);
            this.needToDropSort[n2] = true;
        }
        this.rowSources = new RowLocationRetRowSource[n4];
        SortController[] sortControllerArray = new SortController[n4];
        for (int i = 0; i < n4; ++i) {
            sortControllerArray[i] = this.tc.openSort(this.sortIds[i]);
            sortControllerArray[i].completedInserts();
            this.rowSources[i] = this.tc.openSortRowSource(this.sortIds[i]);
        }
        long[] lArray = new long[n4];
        for (int i = 0; i < n4; ++i) {
            Properties properties = new Properties();
            object = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[i]);
            object2 = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[i], this.indexDCOCIs[i]);
            object2.getInternalTablePropertySet(properties);
            n = execIndexRowArray[i].nColumns();
            properties.put("baseConglomerateId", Long.toString(l));
            if (((ConglomerateDescriptor)object).getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(n - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(n));
            }
            if (((ConglomerateDescriptor)object).getIndexDescriptor().isUniqueWithDuplicateNulls()) {
                properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            }
            properties.put("rowLocationColumn", Integer.toString(n - 1));
            properties.put("nKeyFields", Integer.toString(n));
            object2.close();
            this.collation[i] = insertConstantAction.irgs[i].getColumnCollationIds(tableDescriptor.getColumnDescriptorList());
            lArray[i] = this.tc.createAndLoadConglomerate("BTREE", execIndexRowArray[i].getRowArray(), null, this.collation[i], properties, 0, this.rowSources[i], null);
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[i]), lArray[i], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[i]);
        }
    }

    private BulkTableScanResultSet getTableScanResultSet(long l) throws StandardException {
        if (this.tableScan == null) {
            this.tableScan = new BulkTableScanResultSet(l, this.tc.getStaticCompiledConglomInfo(l), this.activation, new MyRowAllocator(this.fullTemplate), 0, null, 0, null, 0, false, null, "tableName", null, null, false, false, -1, -1, 7, true, 2, 16, false, 0.0, 0.0);
            this.tableScan.openCore();
        } else {
            this.tableScan.reopenCore();
        }
        return this.tableScan;
    }

    private String[] getColumnNames(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.constants.getColumnName(i);
        }
        return stringArray;
    }

    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }

    class MyRowAllocator
    implements GeneratedMethod {
        private ExecRow row;

        MyRowAllocator(ExecRow execRow) {
            this.row = execRow;
        }

        public Object invoke(Object object) {
            return this.row.getClone();
        }
    }
}

