/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable {
    String name;
    String exposedName;
    String tableName;
    String sourceTableName;
    String sourceSchemaName;
    ValueNode expression;
    ColumnDescriptor columnDescriptor;
    boolean isGenerated;
    boolean isGeneratedForUnmatchedColumnInInsert;
    boolean isGroupingColumn;
    boolean isReferenced;
    boolean isRedundant;
    boolean isNameGenerated;
    boolean updated;
    boolean updatableByCursor;
    private boolean defaultColumn;
    private boolean wasDefault;
    boolean autoincrementGenerated;
    boolean autoincrement;
    private int resultSetNumber = -1;
    ColumnReference reference;
    private int virtualColumnId;

    public void init(Object object, Object object2) throws StandardException {
        if (object instanceof String || object == null) {
            this.exposedName = this.name = (String)object;
            this.setExpression((ValueNode)object2);
        } else if (object instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)object;
            this.name = columnReference.getColumnName();
            this.exposedName = columnReference.getColumnName();
            this.reference = columnReference;
            this.setExpression((ValueNode)object2);
        } else if (object instanceof ColumnDescriptor) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)object;
            this.exposedName = this.name = columnDescriptor.getColumnName();
            this.setType(columnDescriptor.getType());
            this.columnDescriptor = columnDescriptor;
            this.setExpression((ValueNode)object2);
            this.autoincrement = columnDescriptor.isAutoincrement();
        } else {
            this.setType((DataTypeDescriptor)object);
            this.setExpression((ValueNode)object2);
            if (object2 instanceof ColumnReference) {
                this.reference = (ColumnReference)object2;
            }
        }
        if (this.expression != null && this.expression.isInstanceOf(100)) {
            this.defaultColumn = true;
        }
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean bl) {
        this.defaultColumn = bl;
    }

    public boolean wasDefaultColumn() {
        return this.wasDefault;
    }

    public void setWasDefaultColumn(boolean bl) {
        this.wasDefault = bl;
    }

    boolean columnNameMatches(String string) {
        return string.equals(this.exposedName) || string.equals(this.name) || string.equals(this.getSourceColumnName());
    }

    String getSourceColumnName() {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getColumnName();
        }
        return null;
    }

    public String getName() {
        return this.exposedName;
    }

    public String getSchemaName() throws StandardException {
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this.expression != null) {
            return this.expression.getSchemaName();
        }
        return null;
    }

    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getName();
        }
        return this.expression.getTableName();
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void clearTableName() {
        if (this.expression instanceof ColumnReference) {
            ((ColumnReference)this.expression).setTableNameNode(null);
        }
    }

    public DataTypeDescriptor getType() {
        return this.getTypeServices();
    }

    public int getColumnPosition() {
        if (this.columnDescriptor != null) {
            return this.columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    public void setExpression(ValueNode valueNode) {
        this.expression = valueNode;
    }

    public ValueNode getExpression() {
        return this.expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.setExpression(this.getNullNode(this.getTypeServices()));
    }

    public void setName(String string) {
        if (this.name == null) {
            this.name = string;
        }
        this.exposedName = string;
    }

    public boolean isNameGenerated() {
        return this.isNameGenerated;
    }

    public void setNameGenerated(boolean bl) {
        this.isNameGenerated = bl;
    }

    public void setResultSetNumber(int n) {
        this.resultSetNumber = n;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public void adjustVirtualColumnId(int n) {
        this.virtualColumnId += n;
    }

    public void setVirtualColumnId(int n) {
        this.virtualColumnId = n;
    }

    public int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    public void collapseVirtualColumnIdGap(int n) {
        if (this.columnDescriptor == null && this.virtualColumnId > n) {
            --this.virtualColumnId;
        }
    }

    public void guaranteeColumnName() throws StandardException {
        if (this.exposedName == null) {
            this.exposedName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this.isNameGenerated = true;
        }
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.expression.requiresTypeFromContext() && this.getTypeServices() != null) {
            this.expression.setType(this.getTypeServices());
        }
        this.setExpression(this.expression.bindExpression(fromList, subqueryList, vector));
        if (this.expression instanceof ColumnReference) {
            this.autoincrement = ((ColumnReference)this.expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n);
        if (columnDescriptor == null) {
            String string = "";
            String string2 = tableDescriptor.getSchemaName();
            if (string2 != null) {
                string = string + string2 + ".";
            }
            string = string + tableDescriptor.getName();
            throw StandardException.newException("42X06", string);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
    }

    public void bindResultColumnByName(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.exposedName);
        if (columnDescriptor == null) {
            String string = "";
            String string2 = tableDescriptor.getSchemaName();
            if (string2 != null) {
                string = string + string2 + ".";
            }
            string = string + tableDescriptor.getName();
            throw StandardException.newException("42X14", (Object)this.exposedName, (Object)string);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
        }
    }

    public void typeUntypedNullExpression(ResultColumn resultColumn) throws StandardException {
        TypeId typeId = resultColumn.getTypeId();
        if (typeId == null) {
            throw StandardException.newException("42X07");
        }
        if (this.expression instanceof UntypedNullConstantNode) {
            this.setExpression(this.getNullNode(resultColumn.getTypeServices()));
        } else if (this.expression instanceof ColumnReference && this.expression.getTypeServices() == null) {
            this.expression.setType(resultColumn.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        this.setType(columnDescriptor.getType());
        this.columnDescriptor = columnDescriptor;
        if (this.reference != null && this.reference.getTableName() != null && !tableDescriptor.getName().equals(this.reference.getTableName())) {
            String string = tableDescriptor.getName();
            String string2 = this.reference.getTableName();
            throw StandardException.newException("42X55", (Object)string, (Object)string2);
        }
    }

    public void bindResultColumnToExpression() throws StandardException {
        this.setType(this.expression.getTypeServices());
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.tableName = columnReference.getTableName();
            this.sourceTableName = columnReference.getSourceTableName();
            this.sourceSchemaName = columnReference.getSourceSchemaName();
        }
    }

    public void setSourceTableName(String string) {
        this.sourceTableName = string;
    }

    public void setSourceSchemaName(String string) {
        this.sourceSchemaName = string;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.expression == null) {
            return this;
        }
        this.setExpression(this.expression.preprocess(n, fromList, subqueryList, predicateList));
        return this;
    }

    public void checkStorableExpression(ResultColumn resultColumn) throws StandardException {
        this.checkStorableExpression((ValueNode)resultColumn);
    }

    private void checkStorableExpression(ValueNode valueNode) throws StandardException {
        TypeId typeId = valueNode.getTypeId();
        if (!this.getTypeCompiler().storable(typeId, this.getClassFactory())) {
            throw StandardException.newException("42821", (Object)this.getTypeId().getSQLTypeName(), (Object)typeId.getSQLTypeName());
        }
    }

    public void checkStorableExpression() throws StandardException {
        this.checkStorableExpression(this.getExpression());
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.expression.generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        if (this.getExpression().requiresTypeFromContext()) {
            return false;
        }
        if (this.getTypeId().isXMLTypeId()) {
            return false;
        }
        DataTypeDescriptor dataTypeDescriptor = this.getExpression().getTypeServices();
        if (!this.getTypeServices().isExactTypeAndLengthMatch(dataTypeDescriptor)) {
            return false;
        }
        return this.getTypeServices().isNullable() || !dataTypeDescriptor.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn resultColumn) throws StandardException {
        ValueNode valueNode = resultColumn.getExpression();
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = resultColumn.getTypeServices();
        if (valueNode != null && valueNode.requiresTypeFromContext() || this.expression.requiresTypeFromContext()) {
            return false;
        }
        if (dataTypeDescriptor.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
            if (valueNode instanceof ConstantNode) {
                DataValueDescriptor dataValueDescriptor;
                ConstantNode constantNode = (ConstantNode)resultColumn.getExpression();
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                if (dataValueDescriptor2 != (dataValueDescriptor = this.convertConstant(dataTypeDescriptor.getTypeId(), dataTypeDescriptor.getMaximumWidth(), dataValueDescriptor2)) && dataValueDescriptor2 instanceof StringDataValue == dataValueDescriptor instanceof StringDataValue) {
                    constantNode.setValue(dataValueDescriptor);
                    constantNode.setType(this.getTypeServices());
                    resultColumn.bindResultColumnToExpression();
                    dataTypeDescriptor2 = resultColumn.getType();
                }
                if (dataValueDescriptor instanceof StringDataValue) {
                    constantNode.setCollationInfo(dataTypeDescriptor);
                    DataValueFactory dataValueFactory = this.getDataValueFactory();
                    dataValueDescriptor = ((StringDataValue)dataValueDescriptor).getValue(dataValueFactory.getCharacterCollator(constantNode.getTypeServices().getCollationType()));
                    constantNode.setValue(dataValueDescriptor);
                }
            }
            if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
                return false;
            }
        }
        if (dataTypeDescriptor.getPrecision() != dataTypeDescriptor2.getPrecision()) {
            return false;
        }
        if (dataTypeDescriptor.getScale() != dataTypeDescriptor2.getScale()) {
            return false;
        }
        if (dataTypeDescriptor.getMaximumWidth() != dataTypeDescriptor2.getMaximumWidth()) {
            return false;
        }
        return dataTypeDescriptor.isNullable() || !dataTypeDescriptor2.isNullable() && !resultColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public boolean isGeneratedForUnmatchedColumnInInsert() {
        return this.isGeneratedForUnmatchedColumnInInsert;
    }

    public void markGenerated() {
        this.isGenerated = true;
        this.isReferenced = true;
    }

    public void markGeneratedForUnmatchedColumnInInsert() {
        this.isGeneratedForUnmatchedColumnInInsert = true;
        this.isReferenced = true;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced() {
        this.isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode valueNode = this.expression;
        while (valueNode != null && valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            if (resultColumn.isReferenced()) {
                this.setReferenced();
                return;
            }
            valueNode = resultColumn.getExpression();
        }
    }

    public void setUnreferenced() {
        this.isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode valueNode = this.expression;
        while (valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            resultColumn.setReferenced();
            valueNode = resultColumn.getExpression();
        }
    }

    public boolean isRedundant() {
        return this.isRedundant;
    }

    public void setRedundant() {
        this.isRedundant = true;
    }

    public void markAsGroupingColumn() {
        this.isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this.expression != null && this.expression.isParameterNode()) {
            throw StandardException.newException("42X34");
        }
    }

    public int compareTo(Object object) {
        ResultColumn resultColumn = (ResultColumn)object;
        return this.getColumnPosition() - resultColumn.getColumnPosition();
    }

    void markUpdated() {
        this.updated = true;
    }

    void markUpdatableByCursor() {
        this.updatableByCursor = true;
    }

    boolean updated() {
        return this.updated;
    }

    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.expression != null) {
            this.expression.disablePrivilegeCollection();
        }
    }

    ResultColumn cloneMe() throws StandardException {
        ResultColumn resultColumn;
        ValueNode valueNode = this.expression instanceof ColumnReference ? ((ColumnReference)this.expression).getClone() : this.expression;
        if (this.columnDescriptor != null) {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.columnDescriptor, this.expression, this.getContextManager());
            resultColumn.setExpression(valueNode);
        } else {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.getName(), valueNode, this.getContextManager());
        }
        resultColumn.setVirtualColumnId(this.getVirtualColumnId());
        resultColumn.setName(this.getName());
        resultColumn.setType(this.getTypeServices());
        resultColumn.setNameGenerated(this.isNameGenerated());
        resultColumn.setSourceTableName(this.getSourceTableName());
        resultColumn.setSourceSchemaName(this.getSourceSchemaName());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            resultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            resultColumn.setReferenced();
        }
        if (this.updated()) {
            resultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            resultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            resultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            resultColumn.setAutoincrement();
        }
        if (this.isGroupingColumn()) {
            resultColumn.markAsGroupingColumn();
        }
        if (this.isGenerated()) {
            resultColumn.markGenerated();
        }
        return resultColumn;
    }

    public int getMaximumColumnSize() {
        return this.getTypeServices().getTypeId().getApproximateLengthInBytes(this.getTypeServices());
    }

    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor dataTypeDescriptor = super.getTypeServices();
        if (dataTypeDescriptor != null) {
            return dataTypeDescriptor;
        }
        if (this.getExpression() != null) {
            return this.getExpression().getTypeServices();
        }
        return null;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = this.isAutoincrementGenerated() ? 0 : (this.expression != null ? this.expression.getOrderableVariantType() : 3);
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.expression != null) {
            this.setExpression((ValueNode)this.expression.accept(visitor));
        }
    }

    public boolean foundInList(String[] stringArray) {
        return this.foundString(stringArray, this.name);
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", this.getTypeId().getSQLTypeName());
        }
    }

    ColumnDescriptor getTableColumnDescriptor() {
        return this.columnDescriptor;
    }

    public boolean isAutoincrementGenerated() {
        return this.autoincrementGenerated;
    }

    public void setAutoincrementGenerated() {
        this.autoincrementGenerated = true;
    }

    public void resetAutoincrementGenerated() {
        this.autoincrementGenerated = false;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement() {
        this.autoincrement = true;
    }

    public boolean isGroupingColumn() {
        return this.isGroupingColumn;
    }

    private DataValueDescriptor convertConstant(TypeId typeId, int n, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = typeId.getTypeFormatId();
        DataValueFactory dataValueFactory = this.getDataValueFactory();
        switch (n2) {
            default: {
                return dataValueDescriptor;
            }
            case 13: {
                String string = dataValueDescriptor.getString();
                int n3 = string.length();
                if (n3 <= n && n2 == 13) {
                    return dataValueFactory.getVarcharDataValue(string);
                }
                for (int i = n; i < n3; ++i) {
                    if (string.charAt(i) == ' ') continue;
                    String string2 = null;
                    if (n2 == 13) {
                        string2 = "VARCHAR";
                    }
                    throw StandardException.newException("22001", (Object)string2, (Object)StringUtil.formatForPrint(string), (Object)String.valueOf(n));
                }
                if (n2 != 13) break;
                return dataValueFactory.getVarcharDataValue(string.substring(0, n));
            }
            case 230: 
        }
        return dataValueFactory.getLongvarcharDataValue(dataValueDescriptor.getString());
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this.reference;
    }

    public BaseColumnNode getBaseColumnNode() {
        ValueNode valueNode = this.expression;
        while (true) {
            if (valueNode instanceof ResultColumn) {
                valueNode = ((ResultColumn)valueNode).expression;
                continue;
            }
            if (valueNode instanceof ColumnReference) {
                valueNode = ((ColumnReference)valueNode).getSource();
                continue;
            }
            if (!(valueNode instanceof VirtualColumnNode)) break;
            valueNode = ((VirtualColumnNode)valueNode).getSourceColumn();
        }
        if (valueNode instanceof BaseColumnNode) {
            return (BaseColumnNode)valueNode;
        }
        return null;
    }

    public int getTableNumber() throws StandardException {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getTableNumber();
        }
        if (this.expression instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.expression;
            if (virtualColumnNode.getSourceResultSet() instanceof FromBaseTable) {
                return ((FromBaseTable)virtualColumnNode.getSourceResultSet()).getTableNumber();
            }
            return virtualColumnNode.getSourceColumn().getTableNumber();
        }
        return -1;
    }

    public boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (valueNode.getNodeType() == this.getNodeType()) {
            ResultColumn resultColumn = (ResultColumn)valueNode;
            if (this.expression != null) {
                return this.expression.isEquivalent(resultColumn.expression);
            }
        }
        return false;
    }

    public boolean hasGenerationClause() {
        return this.columnDescriptor != null && this.columnDescriptor.hasGenerationClause();
    }
}

