/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.IdUtil;

public class TableDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Provider,
Dependent {
    public static final int BASE_TABLE_TYPE = 0;
    public static final int SYSTEM_TABLE_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final int GLOBAL_TEMPORARY_TABLE_TYPE = 3;
    public static final int SYNONYM_TYPE = 4;
    public static final int VTI_TYPE = 5;
    public static final char ROW_LOCK_GRANULARITY = 'R';
    public static final char TABLE_LOCK_GRANULARITY = 'T';
    public static final char DEFAULT_LOCK_GRANULARITY = 'R';
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    SchemaDescriptor schema;
    String tableName;
    UUID oid;
    int tableType;
    long heapConglomNumber = -1L;
    ColumnDescriptorList columnDescriptorList;
    ConglomerateDescriptorList conglomerateDescriptorList;
    ConstraintDescriptorList constraintDescriptorList;
    private GenericDescriptorList triggerDescriptorList;
    ViewDescriptor viewDescriptor;
    private static ThreadLocal referencedColumnMap = new ThreadLocal(){

        protected Object initialValue() {
            return new WeakHashMap();
        }
    };
    private List statisticsDescriptorList;

    private FormatableBitSet referencedColumnMapGet() {
        WeakHashMap weakHashMap = (WeakHashMap)referencedColumnMap.get();
        return (FormatableBitSet)weakHashMap.get(this);
    }

    private void referencedColumnMapPut(FormatableBitSet formatableBitSet) {
        WeakHashMap weakHashMap = (WeakHashMap)referencedColumnMap.get();
        weakHashMap.put(this, formatableBitSet);
    }

    public TableDescriptor(DataDictionary dataDictionary, String string, SchemaDescriptor schemaDescriptor, int n, boolean bl, boolean bl2) {
        this(dataDictionary, string, schemaDescriptor, n, '\u0000');
        this.onCommitDeleteRows = bl;
        this.onRollbackDeleteRows = bl2;
    }

    public TableDescriptor(DataDictionary dataDictionary, String string, SchemaDescriptor schemaDescriptor, int n, char c) {
        super(dataDictionary);
        this.schema = schemaDescriptor;
        this.tableName = string;
        this.tableType = n;
        this.lockGranularity = c;
        this.conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.columnDescriptorList = new ColumnDescriptorList();
        this.constraintDescriptorList = new ConstraintDescriptorList();
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schema;
    }

    public String getName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getQualifiedName() {
        return IdUtil.mkQualifiedName(this.getSchemaName(), this.getName());
    }

    public UUID getUUID() {
        return this.oid;
    }

    public int getTableType() {
        return this.tableType;
    }

    public long getHeapConglomerateId() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        ConglomerateDescriptor conglomerateDescriptor = null;
        if (this.heapConglomNumber != -1L) {
            return this.heapConglomNumber;
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length && (conglomerateDescriptor = conglomerateDescriptorArray[i]).isIndex(); ++i) {
        }
        this.heapConglomNumber = conglomerateDescriptor.getConglomerateNumber();
        return this.heapConglomNumber;
    }

    public int getNumberOfColumns() {
        return this.getColumnDescriptorList().size();
    }

    public FormatableBitSet getReferencedColumnMap() {
        return this.referencedColumnMapGet();
    }

    public void setReferencedColumnMap(FormatableBitSet formatableBitSet) {
        this.referencedColumnMapPut(formatableBitSet);
    }

    public FormatableBitSet makeColumnMap(ColumnDescriptorList columnDescriptorList) {
        FormatableBitSet formatableBitSet = new FormatableBitSet(this.columnDescriptorList.size() + 1);
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            formatableBitSet.set(columnDescriptor.getPosition());
        }
        return formatableBitSet;
    }

    public int getMaxColumnID() throws StandardException {
        int n = 1;
        int n2 = this.getColumnDescriptorList().size();
        for (int i = 0; i < n2; ++i) {
            ColumnDescriptor columnDescriptor = this.columnDescriptorList.elementAt(i);
            n = Math.max(n, columnDescriptor.getPosition());
        }
        return n;
    }

    public void setUUID(UUID uUID) {
        this.oid = uUID;
    }

    public char getLockGranularity() {
        return this.lockGranularity;
    }

    public void setLockGranularity(char c) {
        this.lockGranularity = c;
    }

    public boolean isOnRollbackDeleteRows() {
        return this.onRollbackDeleteRows;
    }

    public boolean isOnCommitDeleteRows() {
        return this.onCommitDeleteRows;
    }

    public void resetHeapConglomNumber() {
        this.heapConglomNumber = -1L;
    }

    public ExecRow getEmptyExecRow() throws StandardException {
        int n = this.getNumberOfColumns();
        ExecRow execRow = this.getDataDictionary().getExecutionFactory().getValueRow(n);
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.columnDescriptorList.elementAt(i);
            DataValueDescriptor dataValueDescriptor = columnDescriptor.getType().getNull();
            execRow.setColumn(i + 1, dataValueDescriptor);
        }
        return execRow;
    }

    public int[] getColumnCollationIds() throws StandardException {
        int[] nArray = new int[this.getNumberOfColumns()];
        for (int i = 0; i < nArray.length; ++i) {
            ColumnDescriptor columnDescriptor = this.columnDescriptorList.elementAt(i);
            nArray[i] = columnDescriptor.getType().getCollationType();
        }
        return nArray;
    }

    public ConglomerateDescriptorList getConglomerateDescriptorList() {
        return this.conglomerateDescriptorList;
    }

    public ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    public void setViewDescriptor(ViewDescriptor viewDescriptor) {
        this.viewDescriptor = viewDescriptor;
    }

    public boolean isPersistent() {
        if (this.tableType == 3) {
            return false;
        }
        return super.isPersistent();
    }

    public boolean isSynonymDescriptor() {
        return this.tableType == 4;
    }

    public int getTotalNumberOfIndexes() throws StandardException {
        int n = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            if (!conglomerateDescriptorArray[i].isIndex()) continue;
            ++n;
        }
        return n;
    }

    public void getAllRelevantTriggers(int n, int[] nArray, GenericDescriptorList genericDescriptorList) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        Enumeration enumeration = dataDictionary.getTriggerDescriptors(this).elements();
        while (enumeration.hasMoreElements()) {
            TriggerDescriptor triggerDescriptor = (TriggerDescriptor)enumeration.nextElement();
            if (!triggerDescriptor.needsToFire(n, nArray)) continue;
            genericDescriptorList.add(triggerDescriptor);
        }
    }

    public void getAllRelevantConstraints(int n, boolean bl, int[] nArray, boolean[] blArray, ConstraintDescriptorList constraintDescriptorList) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        ConstraintDescriptorList constraintDescriptorList2 = dataDictionary.getConstraintDescriptors(this);
        int n2 = constraintDescriptorList2.size();
        for (int i = 0; i < n2; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList2.elementAt(i);
            if (bl && constraintDescriptor.getConstraintType() == 4) continue;
            if (!blArray[0] && constraintDescriptor instanceof ReferencedKeyConstraintDescriptor && n != 3 && n != 2) {
                blArray[0] = ((ReferencedKeyConstraintDescriptor)constraintDescriptor).hasSelfReferencingFK(constraintDescriptorList2, 1);
            }
            if (!constraintDescriptor.needsToFire(n, nArray)) continue;
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor && (n == 3 || n == 2)) {
                blArray[0] = true;
            }
            constraintDescriptorList.add(constraintDescriptor);
        }
    }

    public DependableFinder getDependableFinder() {
        if (this.referencedColumnMapGet() == null) {
            return this.getDependableFinder(137);
        }
        return this.getColumnDependableFinder(393, this.referencedColumnMapGet().getByteArray());
    }

    public String getObjectName() {
        if (this.referencedColumnMapGet() == null) {
            return this.tableName;
        }
        String string = new String(this.tableName);
        boolean bl = true;
        for (int i = 0; i < this.columnDescriptorList.size(); ++i) {
            ColumnDescriptor columnDescriptor = this.columnDescriptorList.elementAt(i);
            if (!this.referencedColumnMapGet().isSet(columnDescriptor.getPosition())) continue;
            if (bl) {
                string = string + "(" + columnDescriptor.getColumnName();
                bl = false;
                continue;
            }
            string = string + ", " + columnDescriptor.getColumnName();
        }
        if (!bl) {
            string = string + ")";
        }
        return string;
    }

    public UUID getObjectID() {
        return this.oid;
    }

    public String getClassType() {
        return "Table";
    }

    public String toString() {
        return "";
    }

    public ColumnDescriptorList getColumnDescriptorList() {
        return this.columnDescriptorList;
    }

    public ColumnDescriptorList getGeneratedColumns() {
        ColumnDescriptorList columnDescriptorList = this.getColumnDescriptorList();
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            if (!columnDescriptor.hasGenerationClause()) continue;
            columnDescriptorList2.add(this.oid, columnDescriptor);
        }
        return columnDescriptorList2;
    }

    public int[] getColumnIDs(String[] stringArray) {
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getColumnDescriptor(stringArray[i]).getPosition();
        }
        return nArray;
    }

    public ConstraintDescriptorList getConstraintDescriptorList() throws StandardException {
        return this.constraintDescriptorList;
    }

    public void setConstraintDescriptorList(ConstraintDescriptorList constraintDescriptorList) {
        this.constraintDescriptorList = constraintDescriptorList;
    }

    public void emptyConstraintDescriptorList() throws StandardException {
        this.constraintDescriptorList = new ConstraintDescriptorList();
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = this.getDataDictionary().getConstraintDescriptors(this);
        return constraintDescriptorList.getPrimaryKey();
    }

    public GenericDescriptorList getTriggerDescriptorList() throws StandardException {
        return this.triggerDescriptorList;
    }

    public void setTriggerDescriptorList(GenericDescriptorList genericDescriptorList) {
        this.triggerDescriptorList = genericDescriptorList;
    }

    public void emptyTriggerDescriptorList() throws StandardException {
        this.triggerDescriptorList = new GenericDescriptorList();
    }

    public boolean tableNameEquals(String string, String string2) {
        String string3 = this.getSchemaName();
        if (string3 == null || string2 == null) {
            return this.tableName.equals(string);
        }
        return string3.equals(string2) && this.tableName.equals(string);
    }

    public void removeConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        this.conglomerateDescriptorList.dropConglomerateDescriptor(this.getUUID(), conglomerateDescriptor);
    }

    public void removeConstraintDescriptor(ConstraintDescriptor constraintDescriptor) throws StandardException {
        this.constraintDescriptorList.remove(constraintDescriptor);
    }

    public ColumnDescriptor getColumnDescriptor(String string) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, string);
    }

    public ColumnDescriptor getColumnDescriptor(int n) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, n);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors() {
        int n = this.conglomerateDescriptorList.size();
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[n];
        this.conglomerateDescriptorList.toArray(conglomerateDescriptorArray);
        return conglomerateDescriptorArray;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long l) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(l);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long l) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(l);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(uUID);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(uUID);
    }

    public IndexLister getIndexLister() throws StandardException {
        return new IndexLister(this);
    }

    public boolean tableHasAutoincrement() {
        int n = this.getColumnDescriptorList().size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.columnDescriptorList.elementAt(i);
            if (!columnDescriptor.isAutoincrement()) continue;
            return true;
        }
        return false;
    }

    public String[] getColumnNamesArray() {
        int n = this.getNumberOfColumns();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getColumnDescriptor(i + 1).getColumnName();
        }
        return stringArray;
    }

    public long[] getAutoincIncrementArray() {
        if (!this.tableHasAutoincrement()) {
            return null;
        }
        int n = this.getNumberOfColumns();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.getColumnDescriptor(i + 1);
            if (!columnDescriptor.isAutoincrement()) continue;
            lArray[i] = columnDescriptor.getAutoincInc();
        }
        return lArray;
    }

    private synchronized List getStatistics() throws StandardException {
        if (this.statisticsDescriptorList != null) {
            return this.statisticsDescriptorList;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        this.statisticsDescriptorList = dataDictionary.getStatisticsDescriptors(this);
        return this.statisticsDescriptorList;
    }

    public boolean statisticsExist(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        List list = this.getStatistics();
        if (conglomerateDescriptor == null) {
            return list.size() > 0;
        }
        UUID uUID = conglomerateDescriptor.getUUID();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StatisticsDescriptor statisticsDescriptor = (StatisticsDescriptor)iterator.next();
            if (!uUID.equals(statisticsDescriptor.getReferenceID())) continue;
            return true;
        }
        return false;
    }

    public double selectivityForConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n) throws StandardException {
        if (!this.statisticsExist(conglomerateDescriptor)) {
            double d = 0.1;
            for (int i = 0; i < n; ++i) {
                d *= 0.1;
            }
            return d;
        }
        UUID uUID = conglomerateDescriptor.getUUID();
        List list = this.getStatistics();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StatisticsDescriptor statisticsDescriptor = (StatisticsDescriptor)iterator.next();
            if (!uUID.equals(statisticsDescriptor.getReferenceID()) || statisticsDescriptor.getColumnCount() != n) continue;
            return statisticsDescriptor.getStatistic().selectivity(null);
        }
        return 0.1;
    }

    public String getDescriptorName() {
        return this.tableName;
    }

    public String getDescriptorType() {
        return this.tableType == 4 ? "Synonym" : "Table/View";
    }

    public synchronized boolean isValid() {
        return true;
    }

    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            default: 
        }
        throw StandardException.newException("X0Y29.S", (Object)dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)this.getQualifiedName());
    }

    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
    }
}

