/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.RowLocation;

public class FKInfo
implements Formatable {
    public static final int FOREIGN_KEY = 1;
    public static final int REFERENCED_KEY = 2;
    public String[] fkConstraintNames;
    public String tableName;
    public int type;
    public UUID refUUID;
    public long refConglomNumber;
    public UUID[] fkUUIDs;
    public long[] fkConglomNumbers;
    public boolean[] fkIsSelfReferencing;
    public int[] colArray;
    public int stmtType;
    public RowLocation rowLocation;
    public int[] raRules;

    public FKInfo() {
    }

    public FKInfo(String[] stringArray, String string, int n, int n2, UUID uUID, long l, UUID[] uUIDArray, long[] lArray, boolean[] blArray, int[] nArray, RowLocation rowLocation, int[] nArray2) {
        this.fkConstraintNames = stringArray;
        this.tableName = string;
        this.stmtType = n;
        this.type = n2;
        this.refUUID = uUID;
        this.refConglomNumber = l;
        this.fkUUIDs = uUIDArray;
        this.fkConglomNumbers = lArray;
        this.fkIsSelfReferencing = blArray;
        this.colArray = nArray;
        this.rowLocation = rowLocation;
        this.raRules = nArray2;
    }

    public static FKInfo[] chooseRelevantFKInfos(FKInfo[] fKInfoArray, int[] nArray, boolean bl) {
        int n;
        int n2;
        if (fKInfoArray == null) {
            return null;
        }
        Vector<FKInfo> vector = new Vector<FKInfo>();
        FKInfo[] fKInfoArray2 = null;
        for (n2 = 0; n2 < fKInfoArray.length; ++n2) {
            if (bl && fKInfoArray[n2].type == 1) {
                vector.addElement(fKInfoArray[n2]);
                continue;
            }
            n = fKInfoArray[n2].colArray.length;
            block1: for (int i = 0; i < n; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (fKInfoArray[n2].colArray[i] != nArray[j]) continue;
                    vector.addElement(fKInfoArray[n2]);
                    i = n;
                    continue block1;
                }
            }
        }
        n2 = vector.size();
        if (n2 > 0) {
            fKInfoArray2 = new FKInfo[n2];
            for (n = 0; n < n2; ++n) {
                fKInfoArray2[n] = (FKInfo)vector.elementAt(n);
            }
        }
        return fKInfoArray2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.rowLocation.getTypeFormatId());
        objectOutput.writeObject(this.tableName);
        objectOutput.writeInt(this.type);
        objectOutput.writeInt(this.stmtType);
        objectOutput.writeObject(this.refUUID);
        objectOutput.writeLong(this.refConglomNumber);
        ArrayUtil.writeArray(objectOutput, this.fkConstraintNames);
        ArrayUtil.writeArray(objectOutput, this.fkUUIDs);
        ArrayUtil.writeLongArray(objectOutput, this.fkConglomNumbers);
        ArrayUtil.writeBooleanArray(objectOutput, this.fkIsSelfReferencing);
        ArrayUtil.writeIntArray(objectOutput, this.colArray);
        ArrayUtil.writeIntArray(objectOutput, this.raRules);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            int n = FormatIdUtil.readFormatIdInteger(objectInput);
            this.rowLocation = (RowLocation)Monitor.newInstanceFromIdentifier(n);
            this.tableName = (String)objectInput.readObject();
            this.type = objectInput.readInt();
            this.stmtType = objectInput.readInt();
            this.refUUID = (UUID)objectInput.readObject();
            this.refConglomNumber = objectInput.readLong();
            this.fkConstraintNames = new String[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.fkConstraintNames);
            this.fkUUIDs = new UUID[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.fkUUIDs);
            this.fkConglomNumbers = ArrayUtil.readLongArray(objectInput);
            this.fkIsSelfReferencing = ArrayUtil.readBooleanArray(objectInput);
            this.colArray = ArrayUtil.readIntArray(objectInput);
            this.raRules = ArrayUtil.readIntArray(objectInput);
        }
        catch (StandardException standardException) {
            throw new StreamCorruptedException(standardException.toString());
        }
    }

    public int getTypeFormatId() {
        return 282;
    }

    public String toString() {
        return "";
    }
}

