/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.api;

import com.egi.services.mff.api.Calibration;
import com.egi.services.mff.api.Channel;
import com.egi.services.mff.api.ChannelStatus;
import com.egi.services.mff.api.Epochs;
import com.egi.services.mff.api.Filter;
import com.egi.services.mff.api.InfoNFileTypeEEG;
import com.egi.services.mff.api.InfoNFileTypeJTF;
import com.egi.services.mff.api.InfoNFileTypePNSData;
import com.egi.services.mff.api.InfoNFileTypeSourceData;
import com.egi.services.mff.api.InfoNFileTypeSpectral;
import com.egi.services.mff.api.InfoNFileTypeTValues;
import com.egi.services.mff.api.LocalMFFFactoryDelegate;
import com.egi.services.mff.api.MFFFactory;
import com.egi.services.mff.api.MFFResource;
import com.egi.services.mff.api.MFFResourceType;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfoN
extends MFFResource {
    public static final String classID = "INON";
    private static String APP_NAME = "InfoN";
    private static String USAGE = "InfoN Unit Test\nUsage: InfoN [OPTIONS]\nwhere [OPTIONS] are:\n-f, --input_filename .................. infoN file (default: ~/MFF_Unit_Tests/InfoN/info1.xml.xml).\n-o, --outut_filename .................. output infoN file (default: ~/MFF_Unit_Tests/InfoN/info1.xml_output.xml).\n-h, -help ...................................... display this help message.\n";
    public static final String SchemaFileName = "sensorlayout_mff";
    public static final String SaveFilePrefix = "sensorLayout";
    private InfoNFileType infoNFileType_ = InfoNFileType.kUnknownInfoNFileType;
    private Object fileTypeInformation_ = null;
    private String continuationFrom_ = null;
    private String continuationTo_ = null;
    private ChannelStatus channelStatus_ = null;
    private ArrayList<Filter> filters_ = null;
    private ArrayList<Calibration> calibrations_ = null;
    private boolean filterAdjusted_ = false;
    private int shiftValue_ = 0;

    public InfoN() {
    }

    public InfoN(String uri, Object resourceDelegate, MFFResourceType resourceType) {
        super(uri, resourceDelegate, resourceType);
    }

    public InfoN copy() throws CloneNotSupportedException {
        return (InfoN)this.clone();
    }

    public void setInfoNFileType(InfoNFileType infoNFileType) {
        this.infoNFileType_ = infoNFileType;
    }

    public InfoNFileType getInfoNFileType() {
        return this.infoNFileType_;
    }

    public void setInfoNFileTypeInformation(Object fileTypeInformation) {
        this.fileTypeInformation_ = fileTypeInformation;
    }

    public Object getInfoNFileTypeInformation() {
        return this.fileTypeInformation_;
    }

    public void setContinuationFrom(String continuationFrom) {
        this.continuationFrom_ = continuationFrom;
    }

    public String getContinuationFrom() {
        return this.continuationFrom_;
    }

    public void setContinuationTo(String continuationTo) {
        this.continuationTo_ = continuationTo;
    }

    public String getContinuationTo() {
        return this.continuationTo_;
    }

    public void setChannelStatus(ChannelStatus channelStatus) {
        this.channelStatus_ = channelStatus;
    }

    public ChannelStatus getChannelStatus() {
        return this.channelStatus_;
    }

    public void setFilters(ArrayList<Filter> filters) {
        this.filters_ = filters;
    }

    public ArrayList<Filter> getFilters() {
        return this.filters_;
    }

    public void setCalibrations(ArrayList<Calibration> calibrations) {
        this.calibrations_ = calibrations;
    }

    public ArrayList<Calibration> getCalibrations() {
        return this.calibrations_;
    }

    public boolean isFilterAdjusted() {
        return this.filterAdjusted_;
    }

    public void setFilterAdjusted(boolean filterAdjusted) {
        this.filterAdjusted_ = filterAdjusted;
    }

    public int getShiftValue() {
        return this.shiftValue_;
    }

    public void setShiftValue(int shiftValue) {
        this.shiftValue_ = shiftValue;
    }

    public String getClassID() {
        return classID;
    }

    public static void main(String[] args) {
        boolean error = false;
        try {
            MFFFactory factory;
            MFFResource resource;
            String userDirectory = System.getProperty("user.dir");
            String defaultInputURI = userDirectory + "/MFF_Unit_Tests/InfoN/info1.xml";
            String defaultOutputURI = userDirectory + "/MFF_Unit_Tests/InfoN/info1_output.xml";
            CmdLineParser commandLineParser = new CmdLineParser();
            CmdLineParser.Option inputFileOpt = commandLineParser.addStringOption('f', "filename");
            CmdLineParser.Option outputFileOpt = commandLineParser.addStringOption('o', "output_filename");
            CmdLineParser.Option helpOpt = commandLineParser.addBooleanOption('h', "help");
            try {
                commandLineParser.parse(args);
            }
            catch (CmdLineParser.OptionException e) {
                System.err.println(e.getMessage());
                System.err.println(USAGE);
                System.exit(-1);
            }
            String inputURI = (String)commandLineParser.getOptionValue(inputFileOpt);
            String outputURI = (String)commandLineParser.getOptionValue(outputFileOpt);
            Boolean help = (Boolean)commandLineParser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                System.err.println(USAGE);
                System.exit(0);
            }
            if (inputURI == null) {
                inputURI = defaultInputURI;
            }
            if (outputURI == null) {
                outputURI = defaultOutputURI;
            }
            if ((resource = (factory = new MFFFactory(new LocalMFFFactoryDelegate())).openResourceAtURI(inputURI, new MFFResourceType(MFFResourceType.MFFResourceTypes.kMFF_RT_InfoN))) instanceof InfoN) {
                InfoN infoN = (InfoN)resource;
                if (infoN.loadResource()) {
                    System.out.println("infoN unit test:");
                    System.out.println("infoN unit test: ------");
                    if (infoN.getInfoNFileType() == InfoNFileType.kEEG && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypeEEG) {
                        InfoNFileTypeEEG infoNFileTypeEEG = (InfoNFileTypeEEG)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: eeg");
                        System.out.println("infoN unit test:    sensor layout name: " + infoNFileTypeEEG.getSensorLayoutName());
                        System.out.println("infoN unit test:    montage name: " + infoNFileTypeEEG.getMontageName());
                        if (infoNFileTypeEEG.getReferenceScheme() != null) {
                            System.out.println("infoN unit test:    reference scheme: " + infoNFileTypeEEG.getReferenceScheme());
                        }
                    } else if (infoN.getInfoNFileType() == InfoNFileType.kSpectral && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypeSpectral) {
                        InfoNFileTypeSpectral infoNFileTypeSpectral = (InfoNFileTypeSpectral)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: spectral");
                    } else if (infoN.getInfoNFileType() == InfoNFileType.kSourceData && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypeSourceData) {
                        InfoNFileTypeSourceData infoNFileTypeSourceData = (InfoNFileTypeSourceData)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: source data");
                    } else if (infoN.getInfoNFileType() == InfoNFileType.kPNSData && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypePNSData) {
                        InfoNFileTypePNSData infoNFileTypePNSData = (InfoNFileTypePNSData)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: pns data");
                    } else if (infoN.getInfoNFileType() == InfoNFileType.kJTF && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypeJTF) {
                        InfoNFileTypeJTF infoNFileTypeJTF = (InfoNFileTypeJTF)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: jtf");
                    } else if (infoN.getInfoNFileType() == InfoNFileType.kTValues && infoN.getInfoNFileTypeInformation() instanceof InfoNFileTypeTValues) {
                        InfoNFileTypeTValues infoNFileTypeTValues = (InfoNFileTypeTValues)infoN.getInfoNFileTypeInformation();
                        System.out.println("infoN unit test:    infoN file type: t values");
                    }
                    if (infoN.getChannelStatus() != null) {
                        ChannelStatus status = infoN.getChannelStatus();
                        System.out.println("infoN unit test:    channel Status");
                        System.out.println("infoN unit test:                   " + status.getExclusion());
                        System.out.println("infoN unit test:" + status.getChannels().toString());
                    }
                    if (infoN.getFilters() != null) {
                        ArrayList<Filter> filterList = infoN.getFilters();
                        for (Filter filter : filterList) {
                            System.out.println("infoN unit test:    Filter");
                            System.out.println("infoN unit test:          " + filter.getMethod());
                            System.out.println("infoN unit test:          " + filter.getType());
                            if (filter.getCutoffFrequencyPresent()) {
                                System.out.println("infoN unit test:          Cuttoff frequency: " + filter.getCutoffFrequency() + filter.getCutoffFrequencyUnits());
                            }
                            if (filter.getPassbandAttenuationPresent()) {
                                System.out.println("infoN unit test:          passband attenuation: " + filter.getPassbandAttenuation() + filter.getPassbandAttenuationUnits());
                            }
                            if (!filter.getSamplingFrequencyPresent()) continue;
                            System.out.println("infoN unit test:          sampling frequency: " + filter.getSamplingFrequency() + filter.getSamplingFrequencyUnits());
                        }
                    }
                    if (infoN.getCalibrations() != null) {
                        ArrayList<Calibration> calibrationList = infoN.getCalibrations();
                        for (Calibration calibration : calibrationList) {
                            System.out.println("infoN unit test:    Calibration: " + calibration.getType());
                            System.out.println("infoN unit test:                BeginTime: " + calibration.getBeginTime());
                            for (Channel channel : calibration.getChannels()) {
                                System.out.println("infoN unit test:               " + channel.getChannelNumber() + " " + channel.getChannelData());
                            }
                        }
                    }
                    System.out.println("infoN unit test: ------");
                    infoN.setURI(outputURI);
                    infoN.saveResource();
                } else {
                    System.out.println("infoN unit test: error: unable to load resource: " + inputURI);
                }
            } else {
                System.out.println("infoN unit test: error: unable to open resource: " + inputURI);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Epochs.class.getName()).log(Level.SEVERE, null, ex);
            error = true;
        }
        if (error) {
            System.exit(-1);
        } else {
            System.exit(0);
        }
    }

    public static enum InfoNFileType {
        kUnknownInfoNFileType(-1),
        kEEG(0),
        kSpectral(1),
        kSourceData(2),
        kPNSData(3),
        kJTF(4),
        kTValues(5);

        private final int value;

        private InfoNFileType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

