/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility.sax;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InfoNParser
extends DefaultHandler {
    private static String APP_NAME = "InfoNParser";
    private static String USAGE = "File Information Parser\nUsage: InfoNParser [OPTIONS]\nwhere [OPTIONS] are:\n-x, --xml ........................................ the xml string to parse.\n-h, -help ...................................... display this help message.\n";
    private int mRequestingProcessUserID = -1;
    private String mRequestingProcessUsername = null;
    private boolean mIsSymbolicLink = false;
    private int mFileUID = -1;
    private String mFileOwner = null;
    private int mFileGID = -1;
    private String mFileGroup = null;
    private String mCurrentElementString;

    public void parseDocument(String xmlString) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(new StringReader(xmlString)), (DefaultHandler)this);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.mCurrentElementString = "";
        if (qName.equalsIgnoreCase("file_info")) {
            this.mRequestingProcessUserID = Integer.parseInt(attributes.getValue("requesting_process_user_id"));
            this.mRequestingProcessUsername = attributes.getValue("requesting_process_username");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mCurrentElementString = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("is_link")) {
            this.mIsSymbolicLink = Boolean.parseBoolean(this.mCurrentElementString);
        }
        if (qName.equalsIgnoreCase("uid")) {
            this.mFileUID = Integer.parseInt(this.mCurrentElementString);
        } else if (qName.equalsIgnoreCase("owner")) {
            this.mFileOwner = this.mCurrentElementString;
        }
        if (qName.equalsIgnoreCase("gid")) {
            this.mFileGID = Integer.parseInt(this.mCurrentElementString);
        } else if (qName.equalsIgnoreCase("group")) {
            this.mFileGroup = this.mCurrentElementString;
        }
    }

    public static void log(String message, boolean error) {
        if (error) {
            System.err.println(APP_NAME + ": " + message);
        } else {
            System.out.println(APP_NAME + ": " + message);
        }
    }

    public static void log(String message) {
        InfoNParser.log(message, false);
    }

    public static void main(String[] args) {
    }
}

