/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import com.egi.services.mff.api.Categories;
import com.egi.services.mff.api.Category;
import com.egi.services.mff.api.Coordinates;
import com.egi.services.mff.api.Entry;
import com.egi.services.mff.api.Epoch;
import com.egi.services.mff.api.Epochs;
import com.egi.services.mff.api.Event;
import com.egi.services.mff.api.EventTrack;
import com.egi.services.mff.api.Field;
import com.egi.services.mff.api.FilePath;
import com.egi.services.mff.api.Filter;
import com.egi.services.mff.api.History;
import com.egi.services.mff.api.Info;
import com.egi.services.mff.api.InfoN;
import com.egi.services.mff.api.InfoNFileTypeEEG;
import com.egi.services.mff.api.InfoNFileTypeJTF;
import com.egi.services.mff.api.InfoNFileTypePNSData;
import com.egi.services.mff.api.InfoNFileTypeSourceData;
import com.egi.services.mff.api.InfoNFileTypeSpectral;
import com.egi.services.mff.api.InfoNFileTypeTValues;
import com.egi.services.mff.api.Key;
import com.egi.services.mff.api.Neighbor;
import com.egi.services.mff.api.PNSSensor;
import com.egi.services.mff.api.PNSSet;
import com.egi.services.mff.api.Segment;
import com.egi.services.mff.api.Sensor;
import com.egi.services.mff.api.SensorLayout;
import com.egi.services.mff.api.Subject;
import com.egi.services.mff.api.Thread;
import com.egi.services.mff.api.Tool;
import com.egi.services.mff.interfaces.MarshallingProtocol;
import com.egi.services.mff.utility.ResourceMarshalException;
import com.egi.services.mff.utility.ResourceUnmarshalException;
import com.egi.services.mff.utility.ResourceValidationException;
import com.egi.services.mff.utility.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLLocalFileResource
implements MarshallingProtocol {
    @Override
    public Object marshal(Object fromObject, String uri) throws ResourceMarshalException {
        Object rVal = fromObject;
        if (fromObject instanceof Categories) {
            Categories categories = (Categories)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("categories");
            root.setAttribute("xmlns", "http://www.egi.com/categories_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Category> categoryList = categories.getCategories();
            if (categoryList != null) {
                for (Category category : categoryList) {
                    Element categoryNode = document.createElement("cat");
                    XMLUtil.appendChild(categoryNode, "name", category.getName(), false, document);
                    ArrayList<Segment> segments = category.getSegments();
                    if (segments != null) {
                        Element segmentsNode = document.createElement("segments");
                        for (Segment segment : segments) {
                            ArrayList<Key> keys;
                            Element segmentNode = document.createElement("seg");
                            XMLUtil.setAttribute(segmentNode, "status", segment.getStatus(), false);
                            XMLUtil.appendChild(segmentNode, "name", segment.getName(), false, document);
                            ArrayList<String> faults = segment.getFaults();
                            if (faults != null) {
                                Element faultsNode = document.createElement("faults");
                                for (String fault : faults) {
                                    XMLUtil.appendChild(faultsNode, "fault", fault, false, document);
                                }
                                segmentNode.appendChild(faultsNode);
                            }
                            if (segment.getClockStartTimePresent()) {
                                XMLUtil.appendChild(segmentNode, "clockStartTime", Long.toString(segment.getClockStartTime()), false, document);
                            }
                            XMLUtil.appendChild(segmentNode, "beginTime", Long.toString(segment.getBeginTime()), false, document);
                            XMLUtil.appendChild(segmentNode, "endTime", Long.toString(segment.getEndTime()), false, document);
                            XMLUtil.appendChild(segmentNode, "evtBegin", Long.toString(segment.getEventBegin()), false, document);
                            XMLUtil.appendChild(segmentNode, "evtEnd", Long.toString(segment.getEventEnd()), false, document);
                            ArrayList<Integer> channels = segment.getChannels();
                            if (channels != null) {
                                int numberOfChannels = channels.size();
                                StringBuilder channelsStringBuffer = new StringBuilder();
                                int channelCount = 0;
                                for (Integer channel : channels) {
                                    if (channelCount == numberOfChannels) {
                                        channelsStringBuffer.append(channel.toString());
                                    } else {
                                        channelsStringBuffer.append(channel.toString()).append(" ");
                                    }
                                    ++channelCount;
                                }
                                channelsStringBuffer.trimToSize();
                                XMLUtil.setAttribute(XMLUtil.appendChild(segmentNode, "channels", channelsStringBuffer.toString(), false, document), "exclusion", segment.getExclusion(), false);
                            }
                            if ((keys = segment.getKeys()) != null) {
                                Element keysNode = document.createElement("keys");
                                segmentNode.appendChild(keysNode);
                                for (Key key : keys) {
                                    if (key == null) continue;
                                    Element keyNode = document.createElement("key");
                                    keysNode.appendChild(keyNode);
                                    XMLUtil.appendChild(keyNode, "keyCode", key.getCode(), false, document);
                                    XMLUtil.appendChild(keyNode, "description", key.getDescription(), false, document);
                                    XMLUtil.setAttribute(XMLUtil.appendChild(keyNode, "data", key.getData(), false, document), "dataType", key.getDataType(), false);
                                }
                            }
                            segmentsNode.appendChild(segmentNode);
                        }
                        categoryNode.appendChild(segmentsNode);
                    }
                    root.appendChild(categoryNode);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Coordinates) {
            Coordinates coordinates = (Coordinates)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("coordinates");
            root.setAttribute("xmlns", "http://www.egi.com/coordinates_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SensorLayout sensorLayout = coordinates.getSensorLayout();
            if (sensorLayout != null) {
                Element sensorLayoutNode = document.createElement("sensorLayout");
                sensorLayoutNode.appendChild(XMLUtil.getElement("name", sensorLayout.getName(), false, document));
                ArrayList<Sensor> sensors = sensorLayout.getSensors();
                if (sensors != null) {
                    Element sensorsNode = document.createElement("sensors");
                    for (Sensor sensor : sensors) {
                        Element sensorNode = document.createElement("sensor");
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("name", sensor.getName(), true, document));
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("number", Integer.toString(sensor.getNumber()), false, document));
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("type", Integer.toString(sensor.getType()), false, document));
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("x", Float.toString(sensor.getX()), false, document));
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("y", Float.toString(sensor.getY()), false, document));
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("z", Float.toString(sensor.getZ()), false, document));
                        if (sensor.getOriginalNumberPresent()) {
                            sensorNode.appendChild(XMLUtil.getElement("originalNumber", Integer.toString(sensor.getOriginalNumber()), false, document));
                        }
                        if (sensor.getIdentifierPresent()) {
                            sensorNode.appendChild(XMLUtil.getElement("identifier", Integer.toString(sensor.getIdentifier()), false, document));
                        }
                        sensorsNode.appendChild(sensorNode);
                    }
                    sensorLayoutNode.appendChild(sensorsNode);
                }
                root.appendChild(sensorLayoutNode);
            }
            root.appendChild(XMLUtil.getElement("acqTime", coordinates.getAcquisitionTime(), false, document));
            root.appendChild(XMLUtil.getElement("acqMethod", coordinates.getAcquisitionMethod(), false, document));
            if (coordinates.getDefaultSubject()) {
                root.appendChild(XMLUtil.getElement("defaultSubject", "true", false, document));
            } else {
                root.appendChild(XMLUtil.getElement("defaultSubject", "false", false, document));
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof SensorLayout) {
            ArrayList<Neighbor> neighbors;
            ArrayList<ArrayList<Integer>> tilingSets;
            ArrayList<Thread> threads;
            SensorLayout sensorLayout = (SensorLayout)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("sensorLayout");
            root.setAttribute("xmlns", "http://www.egi.com/sensorLayout_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.appendChild(XMLUtil.getElement("name", sensorLayout.getName(), false, document));
            ArrayList<Sensor> sensors = sensorLayout.getSensors();
            if (sensors != null) {
                Element sensorsNode = document.createElement("sensors");
                for (Sensor sensor : sensors) {
                    Element sensorNode = document.createElement("sensor");
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("name", sensor.getName(), true, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("number", Integer.toString(sensor.getNumber()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("type", Integer.toString(sensor.getType()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("x", Float.toString(sensor.getX()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("y", Float.toString(sensor.getY()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("z", Float.toString(sensor.getZ()), false, document));
                    if (sensor.getOriginalNumberPresent()) {
                        sensorNode.appendChild(XMLUtil.getElement("originalNumber", Integer.toString(sensor.getOriginalNumber()), false, document));
                    }
                    if (sensor.getIdentifierPresent()) {
                        sensorNode.appendChild(XMLUtil.getElement("identifier", Integer.toString(sensor.getIdentifier()), false, document));
                    }
                    sensorsNode.appendChild(sensorNode);
                }
                root.appendChild(sensorsNode);
            }
            if ((threads = sensorLayout.getThreads()) != null) {
                Element threadsNode = document.createElement("threads");
                for (Thread thread : threads) {
                    String threadString = "" + thread.getFirst() + "," + thread.getSecond();
                    threadsNode.appendChild(XMLUtil.getElement("thread", threadString, false, document));
                }
                root.appendChild(threadsNode);
            }
            if ((tilingSets = sensorLayout.getTilingSets()) != null) {
                Element tilingSetsNode = document.createElement("tilingSets");
                for (ArrayList<Integer> tilingSet : tilingSets) {
                    int numberOfTiles = tilingSet.size();
                    StringBuilder tilesStringBuffer = new StringBuilder();
                    int tileCount = 1;
                    for (Integer tile : tilingSet) {
                        if (tileCount == numberOfTiles) {
                            tilesStringBuffer.append(tile.toString());
                        } else {
                            tilesStringBuffer.append(tile.toString()).append(" ");
                        }
                        ++tileCount;
                    }
                    tilesStringBuffer.trimToSize();
                    tilingSetsNode.appendChild(XMLUtil.getElement("tilingSet", tilesStringBuffer.toString(), false, document));
                }
                root.appendChild(tilingSetsNode);
            }
            if ((neighbors = sensorLayout.getNeighbors()) != null) {
                Element neighborsNode = document.createElement("neighbors");
                for (Neighbor neighbor : neighbors) {
                    ArrayList<Integer> neighborValues = neighbor.getNeighbors();
                    if (neighborValues == null) continue;
                    int numberOfNeighbors = neighborValues.size();
                    StringBuilder neighborsStringBuffer = new StringBuilder();
                    int neighborsCount = 1;
                    for (Integer neighborValue : neighborValues) {
                        if (neighborsCount == numberOfNeighbors) {
                            neighborsStringBuffer.append(neighborValue.toString());
                        } else {
                            neighborsStringBuffer.append(neighborValue.toString()).append(" ");
                        }
                        ++neighborsCount;
                    }
                    neighborsStringBuffer.trimToSize();
                    neighborsNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("ch", neighborsStringBuffer.toString(), false, document), "n", Integer.toString(neighbor.getChannelNumber()), true));
                }
                root.appendChild(neighborsNode);
            }
            XMLUtil.appendChild(root, XMLUtil.getElement("originalLayout", sensorLayout.getOriginalLayout(), false, document));
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Epochs) {
            Epochs epochs = (Epochs)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("epochs");
            root.setAttribute("xmlns", "http://www.egi.com/epochs_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Epoch> epochList = epochs.getEpochs();
            if (epochList != null) {
                for (Epoch epoch : epochList) {
                    Element epochNode = document.createElement("epoch");
                    XMLUtil.appendChild(epochNode, "beginTime", Long.toString(epoch.getBeginTime()), false, document);
                    XMLUtil.appendChild(epochNode, "endTime", Long.toString(epoch.getEndTime()), false, document);
                    XMLUtil.appendChild(epochNode, "firstBlock", Long.toString(epoch.getFirstBlock()), false, document);
                    XMLUtil.appendChild(epochNode, "lastBlock", Long.toString(epoch.getLastBlock()), false, document);
                    root.appendChild(epochNode);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof EventTrack) {
            EventTrack eventTrack = (EventTrack)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("eventTrack");
            root.setAttribute("xmlns", "http://www.egi.com/event_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XMLUtil.appendChild(root, "name", eventTrack.getName(), false, document);
            XMLUtil.appendChild(root, "trackType", eventTrack.getTrackType(), false, document);
            ArrayList<Event> events = eventTrack.getEvents();
            if (events != null) {
                for (Event event : events) {
                    if (event == null) continue;
                    Element eventNode = document.createElement("event");
                    root.appendChild(eventNode);
                    XMLUtil.appendChild(eventNode, "beginTime", event.getBeginTime(), false, document);
                    XMLUtil.appendChild(eventNode, "duration", Long.toString(event.getDuration()), false, document);
                    XMLUtil.appendChild(eventNode, "code", event.getCode(), false, document);
                    XMLUtil.appendChild(eventNode, "label", event.getLabel(), false, document);
                    XMLUtil.appendChild(eventNode, "description", event.getDescription(), false, document);
                    XMLUtil.appendChild(eventNode, "sourceDevice", event.getSourceDevice(), false, document);
                    ArrayList<Key> keys = event.getKeys();
                    if (keys == null) continue;
                    Element keysNode = document.createElement("keys");
                    eventNode.appendChild(keysNode);
                    for (Key key : keys) {
                        if (key == null) continue;
                        Element keyNode = document.createElement("key");
                        keysNode.appendChild(keyNode);
                        XMLUtil.appendChild(keyNode, "keyCode", key.getCode(), false, document);
                        XMLUtil.appendChild(keyNode, "description", key.getDescription(), false, document);
                        XMLUtil.setAttribute(XMLUtil.appendChild(keyNode, "data", key.getData(), false, document), "dataType", key.getDataType(), false);
                    }
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof History) {
            History history = (History)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("historyEntries");
            root.setAttribute("xmlns", "http://www.egi.com/history_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Entry> entries = history.getEntries();
            if (entries != null) {
                for (Entry entry : entries) {
                    if (entry == null) continue;
                    Element entryNode = document.createElement("entry");
                    if (entry.getType().equals("tool")) {
                        ArrayList<String> results;
                        ArrayList<String> settings;
                        Element toolNode = document.createElement("tool");
                        Tool tool = (Tool)entry.getEntry();
                        toolNode.appendChild(XMLUtil.getElement("name", tool.getName(), false, document));
                        toolNode.appendChild(XMLUtil.getElement("kind", tool.getKind(), false, document));
                        toolNode.appendChild(XMLUtil.getElement("method", tool.getMethod(), false, document));
                        toolNode.appendChild(XMLUtil.getElement("version", tool.getVersion(), false, document));
                        toolNode.appendChild(XMLUtil.getElement("beginTime", tool.getBeginTime(), false, document));
                        toolNode.appendChild(XMLUtil.getElement("endTime", tool.getEndTime(), false, document));
                        ArrayList<FilePath> sourceFiles = tool.getSourceFiles();
                        if (sourceFiles != null) {
                            Element sourceFilesNode = document.createElement("sourceFiles");
                            for (FilePath filePath : sourceFiles) {
                                Element filePathNode = XMLUtil.getElement("filePath", filePath.getFilePath(), false, document);
                                XMLUtil.setAttribute(filePathNode, "type", filePath.getType(), false);
                                XMLUtil.setAttribute(filePathNode, "creator", filePath.getCreator(), false);
                                sourceFilesNode.appendChild(filePathNode);
                            }
                            toolNode.appendChild(sourceFilesNode);
                        }
                        if ((settings = tool.getSettings()) != null) {
                            Element settingsNode = document.createElement("settings");
                            for (String setting : settings) {
                                settingsNode.appendChild(XMLUtil.getElement("setting", setting, false, document));
                            }
                            toolNode.appendChild(settingsNode);
                        }
                        if ((results = tool.getResults()) != null) {
                            Element resultsNode = document.createElement("results");
                            for (String result : results) {
                                resultsNode.appendChild(XMLUtil.getElement("result", result, false, document));
                            }
                            toolNode.appendChild(resultsNode);
                        }
                        entryNode.appendChild(toolNode);
                    }
                    root.appendChild(entryNode);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Info) {
            Info info = (Info)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("fileInfo");
            root.setAttribute("xmlns", "http://www.egi.com/info_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (info.getMFFVersionPresent()) {
                root.appendChild(XMLUtil.getElement("mffVersion", Integer.toString(info.getMFFVersion()), false, document));
            }
            root.appendChild(XMLUtil.getElement("recordTime", info.getRecordTime(), false, document));
            root.appendChild(XMLUtil.getElement("ampSerialNumber", info.getAmpSerialNumber(), false, document));
            root.appendChild(XMLUtil.getElement("ampFirmwareVersion", info.getAmpFirmwareVersion(), false, document));
            if (info.getMovieDeltaPresent()) {
                root.appendChild(XMLUtil.getElement("movieDelta", Long.toString(info.getMovieDelta()), false, document));
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof InfoN) {
            ArrayList<Filter> filters;
            InfoN infoN = (InfoN)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("dataInfo");
            root.setAttribute("xmlns", "http://www.egi.com/info_n_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            Element generalInformationElement = document.createElement("generalInformation");
            Element fileDataTypeElement = document.createElement("fileDataType");
            switch (infoN.getInfoNFileType()) {
                case -1: {
                    break;
                }
                case 0: {
                    Element eegTypeElement = document.createElement("EEG");
                    eegTypeElement.appendChild(document.createElement("EEGFile"));
                    InfoNFileTypeEEG infoNFileTypeEEG = (InfoNFileTypeEEG)infoN.getInfoNFileTypeInformation();
                    eegTypeElement.appendChild(XMLUtil.getElement("sensorLayoutName", infoNFileTypeEEG.getSensorLayoutName(), false, document));
                    eegTypeElement.appendChild(XMLUtil.getElement("montageName", infoNFileTypeEEG.getMontageName(), false, document));
                    fileDataTypeElement.appendChild(eegTypeElement);
                    break;
                }
                case 1: {
                    Element spectralTypeElement = document.createElement("spectral");
                    spectralTypeElement.appendChild(document.createElement("spectralFile"));
                    InfoNFileTypeSpectral infoNFileTypeSpectral = (InfoNFileTypeSpectral)infoN.getInfoNFileTypeInformation();
                    spectralTypeElement.appendChild(XMLUtil.getElement("sensorLayoutName", infoNFileTypeSpectral.getSensorLayoutName(), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("montageName", infoNFileTypeSpectral.getMontageName(), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("deltaF", Double.toString(infoNFileTypeSpectral.getDeltaF()), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("path", infoNFileTypeSpectral.getPath(), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("beginTime", Long.toString(infoNFileTypeSpectral.getBeginTime()), false, document));
                    if (infoNFileTypeSpectral.getEndTimePresent()) {
                        spectralTypeElement.appendChild(XMLUtil.getElement("endTime", Long.toString(infoNFileTypeSpectral.getEndTime()), false, document));
                    }
                    spectralTypeElement.appendChild(XMLUtil.getElement("minX", Float.toString(infoNFileTypeSpectral.getMinX()), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("maxX", Float.toString(infoNFileTypeSpectral.getMaxX()), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("minY", Float.toString(infoNFileTypeSpectral.getMinY()), false, document));
                    spectralTypeElement.appendChild(XMLUtil.getElement("maxY", Float.toString(infoNFileTypeSpectral.getMaxY()), false, document));
                    fileDataTypeElement.appendChild(spectralTypeElement);
                    break;
                }
                case 2: {
                    Element sourceDataTypeElement = document.createElement("sourceData");
                    sourceDataTypeElement.appendChild(document.createElement("sourceDataFile"));
                    InfoNFileTypeSourceData infoNFileTypeSourceData = (InfoNFileTypeSourceData)infoN.getInfoNFileTypeInformation();
                    sourceDataTypeElement.appendChild(XMLUtil.getElement("dipoleSetName", infoNFileTypeSourceData.getDipoleSetName(), false, document));
                    sourceDataTypeElement.appendChild(XMLUtil.getElement("numberOfOrientation", Long.toString(infoNFileTypeSourceData.getNumberOfOrientation()), false, document));
                    fileDataTypeElement.appendChild(sourceDataTypeElement);
                    break;
                }
                case 3: {
                    Element pnsTypeElement = document.createElement("PNSData");
                    pnsTypeElement.appendChild(document.createElement("PNSDataFile"));
                    InfoNFileTypePNSData infoNFileTypePNSData = (InfoNFileTypePNSData)infoN.getInfoNFileTypeInformation();
                    pnsTypeElement.appendChild(XMLUtil.getElement("pnsSetName", infoNFileTypePNSData.getPNSSetName(), false, document));
                    fileDataTypeElement.appendChild(pnsTypeElement);
                    break;
                }
                case 4: {
                    Element jtfTypeElement = document.createElement("JTF");
                    jtfTypeElement.appendChild(document.createElement("JTFFile"));
                    InfoNFileTypeJTF infoNFileTypeJTF = (InfoNFileTypeJTF)infoN.getInfoNFileTypeInformation();
                    jtfTypeElement.appendChild(XMLUtil.getElement("sensorLayoutName", infoNFileTypeJTF.getSensorLayoutName(), false, document));
                    jtfTypeElement.appendChild(XMLUtil.getElement("montageName", infoNFileTypeJTF.getMontageName(), false, document));
                    jtfTypeElement.appendChild(XMLUtil.getElement("path", infoNFileTypeJTF.getPath(), false, document));
                    jtfTypeElement.appendChild(XMLUtil.getElement("samplingRate", Long.toString(infoNFileTypeJTF.getSamplingRate()), false, document));
                    fileDataTypeElement.appendChild(jtfTypeElement);
                    break;
                }
                case 5: {
                    Element tValuesTypeElement = document.createElement("tValues");
                    tValuesTypeElement.appendChild(document.createElement("tValuesFile"));
                    InfoNFileTypeTValues infoNFileTypeTValues = (InfoNFileTypeTValues)infoN.getInfoNFileTypeInformation();
                    tValuesTypeElement.appendChild(XMLUtil.getElement("sensorLayoutName", infoNFileTypeTValues.getSensorLayoutName(), false, document));
                    tValuesTypeElement.appendChild(XMLUtil.getElement("montageName", infoNFileTypeTValues.getMontageName(), false, document));
                    fileDataTypeElement.appendChild(tValuesTypeElement);
                }
            }
            ArrayList<Integer> channels = infoN.getChannels();
            if (channels != null) {
                int numberOfChannels = channels.size();
                StringBuilder channelsStringBuffer = new StringBuilder();
                int channelCount = 0;
                for (Integer channel : channels) {
                    if (channelCount == numberOfChannels) {
                        channelsStringBuffer.append(channel.toString());
                    } else {
                        channelsStringBuffer.append(channel.toString()).append(" ");
                    }
                    ++channelCount;
                }
                channelsStringBuffer.trimToSize();
                XMLUtil.setAttribute(XMLUtil.appendChild(root, "channels", channelsStringBuffer.toString(), false, document), "exclusion", infoN.getExclusion(), false);
            }
            if ((filters = infoN.getFilters()) != null) {
                Element filtersNode = document.createElement("filters");
                for (Filter filter : filters) {
                    Element filterNode = document.createElement("filter");
                    filterNode.appendChild(XMLUtil.getElement("beginTime", Long.toString(filter.getBeginTime()), false, document));
                    if (filter.getEndTimePresent()) {
                        filterNode.appendChild(XMLUtil.getElement("endTime", Long.toString(filter.getEndTime()), false, document));
                    }
                    filterNode.appendChild(XMLUtil.getElement("method", filter.getMethod(), false, document));
                    filterNode.appendChild(XMLUtil.getElement("type", filter.getType(), false, document));
                    if (filter.getSamplingFrequencyPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("samplingFrequency", Double.toString(filter.getSamplingFrequency()), false, document), "units", filter.getSamplingFrequencyUnits(), false));
                    }
                    if (filter.getCutoffFrequencyPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("cutoffFrequency", Double.toString(filter.getCutoffFrequency()), false, document), "units", filter.getCutoffFrequencyUnits(), false));
                    }
                    if (filter.getPassbandAttenuationPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("passbandAttenuation", Double.toString(filter.getPassbandAttenuation()), false, document), "units", filter.getPassbandAttenuationUnits(), false));
                    }
                    filtersNode.appendChild(filterNode);
                }
                root.appendChild(filtersNode);
            }
            generalInformationElement.appendChild(fileDataTypeElement);
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Subject) {
            ArrayList<String> mris;
            Subject subject = (Subject)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("patient");
            root.setAttribute("xmlns", "http://www.egi.com/subject_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Field> fields = subject.getFields();
            if (fields != null) {
                Element fieldsNode = document.createElement("fields");
                for (Field field : fields) {
                    if (field == null) continue;
                    Element fieldNode = document.createElement("field");
                    fieldNode.appendChild(XMLUtil.getElement("name", field.getName(), false, document));
                    fieldNode.appendChild(XMLUtil.getElement("data", field.getData(), false, document));
                    fieldNode.appendChild(XMLUtil.getElement("dataType", field.getDataType(), false, document));
                    fieldsNode.appendChild(fieldNode);
                }
                root.appendChild(fieldsNode);
            }
            if ((mris = subject.getMRIS()) != null) {
                Element mrisNode = document.createElement("MRIs");
                for (String fileName : mris) {
                    mrisNode.appendChild(XMLUtil.getElement("fileName", fileName, false, document));
                }
                root.appendChild(mrisNode);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof PNSSet) {
            PNSSet pnsSet = (PNSSet)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("PNSSet");
            root.setAttribute("xmlns", "http://www.egi.com/pnsSet_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.appendChild(XMLUtil.getElement("name", pnsSet.getName(), false, document));
            ArrayList<PNSSensor> pnsSensors = pnsSet.getPNSSensors();
            if (pnsSensors != null) {
                Element sensorsNode = document.createElement("sensors");
                for (PNSSensor pnsSensor : pnsSensors) {
                    Element sensorNode = document.createElement("sensor");
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("name", pnsSensor.getName(), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("number", Integer.toString(pnsSensor.getNumber()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("unit", pnsSensor.getUnit(), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("psgType", Integer.toString(pnsSensor.getPSGType()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("mapping", Integer.toString(pnsSensor.getMapping()), false, document));
                    XMLUtil.appendChild(sensorNode, XMLUtil.getElement("samplingRate", Long.toString(pnsSensor.getSamplingRate()), false, document));
                    if (pnsSensor.getHighpassPresent()) {
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("highpass", Double.toString(pnsSensor.getHighpass()), false, document));
                    }
                    if (pnsSensor.getLowpassPresent()) {
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("lowpass", Double.toString(pnsSensor.getLowpass()), false, document));
                    }
                    if (pnsSensor.getNotchPresent()) {
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("notch", Double.toString(pnsSensor.getNotch()), false, document));
                    }
                    if (pnsSensor.getGroupNumberPresent()) {
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("groupNumber", Integer.toString(pnsSensor.getGroupNumber()), false, document));
                    }
                    if (pnsSensor.getConversionPresent()) {
                        XMLUtil.appendChild(sensorNode, XMLUtil.getElement("conversion", Integer.toString(pnsSensor.getConversion()), false, document));
                    }
                    sensorsNode.appendChild(sensorNode);
                }
                root.appendChild(sensorsNode);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        return rVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object unmarshal(Object toObject, String uri) throws ResourceUnmarshalException {
        Object rVal = toObject;
        if (toObject instanceof Categories) {
            Categories categories = (Categories)toObject;
            ArrayList<Category> categoryList = new ArrayList<Category>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("categories")) return rVal;
            for (Node categoriesChild = root.getFirstChild(); categoriesChild != null; categoriesChild = categoriesChild.getNextSibling()) {
                if (!categoriesChild.getNodeName().equals("cat")) continue;
                Category category = new Category();
                for (Node categoryChild = categoriesChild.getFirstChild(); categoryChild != null; categoryChild = categoryChild.getNextSibling()) {
                    if (categoryChild.getNodeName().equals("name")) {
                        category.setName(categoryChild.getTextContent());
                        continue;
                    }
                    if (!categoryChild.getNodeName().equals("segments")) continue;
                    ArrayList<Segment> segments = new ArrayList<Segment>();
                    for (Node segmentsChild = categoryChild.getFirstChild(); segmentsChild != null; segmentsChild = segmentsChild.getNextSibling()) {
                        if (!segmentsChild.getNodeName().equals("seg")) continue;
                        Segment segment = new Segment();
                        segment.setStatus(XMLUtil.getAttribute(segmentsChild, "status"));
                        for (Node segmentChild = segmentsChild.getFirstChild(); segmentChild != null; segmentChild = segmentChild.getNextSibling()) {
                            if (segmentChild.getNodeName().equals("name")) {
                                segment.setName(segmentChild.getTextContent());
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("faults")) {
                                ArrayList<String> faults = new ArrayList<String>();
                                for (Node faultsChild = segmentChild.getFirstChild(); faultsChild != null; faultsChild = faultsChild.getNextSibling()) {
                                    faults.add(faultsChild.getTextContent());
                                }
                                segment.setFaults(faults);
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("clockStartTime")) {
                                segment.setClockStartTime(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("beginTime")) {
                                segment.setBeginTime(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("endTime")) {
                                segment.setEndTime(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("evtBegin")) {
                                segment.setEventBegin(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("evtEnd")) {
                                segment.setEventEnd(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("channels") || !segmentChild.getNodeName().equals("keys")) continue;
                            ArrayList<Key> keys = new ArrayList<Key>();
                            for (Node keysChild = segmentChild.getFirstChild(); keysChild != null; keysChild = keysChild.getNextSibling()) {
                                if (!keysChild.getNodeName().equals("key")) continue;
                                Key key = new Key();
                                for (Node keyChild = keysChild.getFirstChild(); keyChild != null; keyChild = keyChild.getNextSibling()) {
                                    if (keyChild.getNodeName().equals("keyCode")) {
                                        key.setCode(keyChild.getTextContent());
                                        continue;
                                    }
                                    if (keyChild.getNodeName().equals("description")) {
                                        key.setDescription(keyChild.getTextContent());
                                        continue;
                                    }
                                    if (!keyChild.getNodeName().equals("data")) continue;
                                    key.setDataType(XMLUtil.getAttribute(keyChild, "dataType"));
                                    key.setData(keyChild.getTextContent());
                                }
                                keys.add(key);
                            }
                            segment.setKeys(keys);
                        }
                        segments.add(segment);
                    }
                    category.setSegments(segments);
                }
                categoryList.add(category);
            }
            categories.setCategories(categoryList);
            return rVal;
        }
        if (toObject instanceof Coordinates) {
            Element root;
            Coordinates coordinates = (Coordinates)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root = document.getDocumentElement()) == null) return rVal;
            root.normalize();
            if (!root.getNodeName().equals("coordinates")) return rVal;
            for (Node coordinatesChild = root.getFirstChild(); coordinatesChild != null; coordinatesChild = coordinatesChild.getNextSibling()) {
                if (coordinatesChild.getNodeName().equals("sensorLayout")) {
                    SensorLayout sensorLayout = new SensorLayout();
                    for (Node sensorLayoutChild = coordinatesChild.getFirstChild(); sensorLayoutChild != null; sensorLayoutChild = sensorLayoutChild.getNextSibling()) {
                        if (sensorLayoutChild.getNodeName().equals("name")) {
                            sensorLayout.setName(sensorLayoutChild.getTextContent());
                            continue;
                        }
                        if (!sensorLayoutChild.getNodeName().equals("sensors")) continue;
                        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
                        for (Node sensorsChild = sensorLayoutChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                            if (!sensorsChild.getNodeName().equals("sensor")) continue;
                            Sensor sensor = new Sensor();
                            for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                                if (sensorChild.getNodeName().equals("name")) {
                                    sensor.setName(sensorChild.getTextContent());
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("number")) {
                                    sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("type")) {
                                    sensor.setType(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("x")) {
                                    sensor.setX(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("y")) {
                                    sensor.setY(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("z")) {
                                    sensor.setZ(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("originalNumber")) {
                                    sensor.setOriginalNumber(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (!sensorChild.getNodeName().equals("identifier")) continue;
                                sensor.setIdentifier(Integer.parseInt(sensorChild.getTextContent()));
                            }
                            sensors.add(sensor);
                        }
                        sensorLayout.setSensors(sensors);
                    }
                    coordinates.setSensorLayout(sensorLayout);
                    continue;
                }
                if (coordinatesChild.getNodeName().equals("acqTime")) {
                    coordinates.setAcquisitionTime(coordinatesChild.getTextContent());
                    continue;
                }
                if (coordinatesChild.getNodeName().equals("acqMethod")) {
                    coordinates.setAcquisitionMethod(coordinatesChild.getTextContent());
                    continue;
                }
                if (!coordinatesChild.getNodeName().equals("defaultSubject")) continue;
                if (coordinatesChild.getTextContent().equals("true")) {
                    coordinates.setDefaultSubject(true);
                    continue;
                }
                coordinates.setDefaultSubject(false);
            }
            return rVal;
        }
        if (toObject instanceof SensorLayout) {
            Element root;
            SensorLayout sensorLayout = (SensorLayout)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root = document.getDocumentElement()) == null) return rVal;
            root.normalize();
            if (!root.getNodeName().equals("sensorLayout")) return rVal;
            for (Node sensorLayoutChild = root.getFirstChild(); sensorLayoutChild != null; sensorLayoutChild = sensorLayoutChild.getNextSibling()) {
                String[] parts;
                if (sensorLayoutChild.getNodeName().equals("name")) {
                    sensorLayout.setName(sensorLayoutChild.getTextContent());
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("sensors")) {
                    ArrayList<Sensor> sensors = new ArrayList<Sensor>();
                    for (Node sensorsChild = sensorLayoutChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                        if (!sensorsChild.getNodeName().equals("sensor")) continue;
                        Sensor sensor = new Sensor();
                        for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                            if (sensorChild.getNodeName().equals("name")) {
                                sensor.setName(sensorChild.getTextContent());
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("number")) {
                                sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("type")) {
                                sensor.setType(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("x")) {
                                sensor.setX(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("y")) {
                                sensor.setY(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("z")) {
                                sensor.setZ(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("originalNumber")) {
                                sensor.setOriginalNumber(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (!sensorChild.getNodeName().equals("identifier")) continue;
                            sensor.setIdentifier(Integer.parseInt(sensorChild.getTextContent()));
                        }
                        sensors.add(sensor);
                    }
                    sensorLayout.setSensors(sensors);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("threads")) {
                    ArrayList<Thread> threads = new ArrayList<Thread>();
                    for (Node threadsChild = sensorLayoutChild.getFirstChild(); threadsChild != null; threadsChild = threadsChild.getNextSibling()) {
                        String threadString;
                        if (!threadsChild.getNodeName().equals("thread") || (threadString = threadsChild.getTextContent()) == null) continue;
                        Thread thread = new Thread();
                        parts = threadString.split(",");
                        if (parts.length == 2) {
                            thread.setFirst(Integer.parseInt(parts[0].trim()));
                            thread.setSecond(Integer.parseInt(parts[1].trim()));
                        }
                        threads.add(thread);
                    }
                    sensorLayout.setThreads(threads);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("tilingSets")) {
                    ArrayList<ArrayList<Integer>> tilingSets = new ArrayList<ArrayList<Integer>>();
                    for (Node tilingSetsChild = sensorLayoutChild.getFirstChild(); tilingSetsChild != null; tilingSetsChild = tilingSetsChild.getNextSibling()) {
                        String tilingSetString;
                        if (!tilingSetsChild.getNodeName().equals("tilingSet") || (tilingSetString = tilingSetsChild.getTextContent()) == null) continue;
                        ArrayList<Integer> tilingSet = new ArrayList<Integer>();
                        for (String tilingSetMember : parts = tilingSetString.split(" ")) {
                            tilingSet.add(Integer.parseInt(tilingSetMember.trim()));
                        }
                        tilingSets.add(tilingSet);
                    }
                    sensorLayout.setTilingSets(tilingSets);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("neighbors")) {
                    ArrayList<Neighbor> neighbors = new ArrayList<Neighbor>();
                    for (Node neighborsChild = sensorLayoutChild.getFirstChild(); neighborsChild != null; neighborsChild = neighborsChild.getNextSibling()) {
                        if (!neighborsChild.getNodeName().equals("ch")) continue;
                        try {
                            String[] parts2;
                            Neighbor neighbor = new Neighbor();
                            neighbor.setChannelNumber(Integer.parseInt(XMLUtil.getAttribute(neighborsChild, "n")));
                            String neighborsForNeighborString = neighborsChild.getTextContent();
                            if (neighborsForNeighborString == null) continue;
                            ArrayList<Integer> neighborsForNeighbor = new ArrayList<Integer>();
                            for (String neighborForNeighbor : parts2 = neighborsForNeighborString.split(" ")) {
                                neighborsForNeighbor.add(Integer.parseInt(neighborForNeighbor.trim()));
                            }
                            neighbor.setNeighbors(neighborsForNeighbor);
                            neighbors.add(neighbor);
                            continue;
                        }
                        catch (Exception exp) {
                            System.out.println("XMLLocalFileResource: error: could not add neighbor set: " + exp.getClass());
                        }
                    }
                    sensorLayout.setNeighbors(neighbors);
                    continue;
                }
                if (!sensorLayoutChild.getNodeName().equals("originalLayout")) continue;
                sensorLayout.setOriginalLayout(sensorLayoutChild.getTextContent());
            }
            return rVal;
        }
        if (toObject instanceof Epochs) {
            Epochs epochs = (Epochs)toObject;
            ArrayList<Epoch> epochList = new ArrayList<Epoch>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("epochs")) return rVal;
            for (Node epochsChild = root.getFirstChild(); epochsChild != null; epochsChild = epochsChild.getNextSibling()) {
                if (!epochsChild.getNodeName().equals("epoch")) continue;
                Epoch epoch = new Epoch();
                for (Node epochChild = epochsChild.getFirstChild(); epochChild != null; epochChild = epochChild.getNextSibling()) {
                    if (epochChild.getNodeName().equals("beginTime")) {
                        epoch.setBeginTime(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (epochChild.getNodeName().equals("endTime")) {
                        epoch.setEndTime(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (epochChild.getNodeName().equals("firstBlock")) {
                        epoch.setFirstBlock(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (!epochChild.getNodeName().equals("lastBlock")) continue;
                    epoch.setLastBlock(Long.parseLong(epochChild.getTextContent()));
                }
                epochList.add(epoch);
            }
            epochs.setEpochs(epochList);
            return rVal;
        }
        if (toObject instanceof EventTrack) {
            EventTrack eventTrack = (EventTrack)toObject;
            ArrayList<Event> events = new ArrayList<Event>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("eventTrack")) return rVal;
            for (Node eventTrackChild = root.getFirstChild(); eventTrackChild != null; eventTrackChild = eventTrackChild.getNextSibling()) {
                if (eventTrackChild.getNodeName().equals("name")) {
                    eventTrack.setName(eventTrackChild.getTextContent());
                    continue;
                }
                if (eventTrackChild.getNodeName().equals("trackType")) {
                    eventTrack.setTrackType(eventTrackChild.getTextContent());
                    continue;
                }
                if (!eventTrackChild.getNodeName().equals("event")) continue;
                Event event = new Event();
                for (Node eventChild = eventTrackChild.getFirstChild(); eventChild != null; eventChild = eventChild.getNextSibling()) {
                    if (eventChild.getNodeName().equals("beginTime")) {
                        event.setBeginTime(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("duration")) {
                        event.setDuration(Long.parseLong(eventChild.getTextContent()));
                        continue;
                    }
                    if (eventChild.getNodeName().equals("code")) {
                        event.setCode(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("label")) {
                        event.setLabel(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("description")) {
                        event.setDescription(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("sourceDevice")) {
                        event.setSourceDevice(eventChild.getTextContent());
                        continue;
                    }
                    if (!eventChild.getNodeName().equals("keys")) continue;
                    ArrayList<Key> keys = new ArrayList<Key>();
                    for (Node keysChild = eventChild.getFirstChild(); keysChild != null; keysChild = keysChild.getNextSibling()) {
                        if (!keysChild.getNodeName().equals("key")) continue;
                        Key key = new Key();
                        for (Node keyChild = keysChild.getFirstChild(); keyChild != null; keyChild = keyChild.getNextSibling()) {
                            if (keyChild.getNodeName().equals("keyCode")) {
                                key.setCode(keyChild.getTextContent());
                                continue;
                            }
                            if (keyChild.getNodeName().equals("description")) {
                                key.setDescription(keyChild.getTextContent());
                                continue;
                            }
                            if (!keyChild.getNodeName().equals("data")) continue;
                            key.setDataType(XMLUtil.getAttribute(keyChild, "dataType"));
                            key.setData(keyChild.getTextContent());
                        }
                        keys.add(key);
                    }
                    event.setKeys(keys);
                }
                events.add(event);
            }
            eventTrack.setEvents(events);
            return rVal;
        }
        if (toObject instanceof History) {
            History history = (History)toObject;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document != null) {
                Element root = document.getDocumentElement();
                if (root != null) {
                    root.normalize();
                }
                if (root.getNodeName().equals("historyEntries")) {
                    for (Node historyEntriesChild = root.getFirstChild(); historyEntriesChild != null; historyEntriesChild = historyEntriesChild.getNextSibling()) {
                        if (!historyEntriesChild.getNodeName().equals("entry")) continue;
                        Entry entry = new Entry();
                        for (Node entryChild = historyEntriesChild.getFirstChild(); entryChild != null; entryChild = entryChild.getNextSibling()) {
                            if (!entryChild.getNodeName().equals("tool")) continue;
                            Tool tool = new Tool();
                            for (Node toolChild = entryChild.getFirstChild(); toolChild != null; toolChild = toolChild.getNextSibling()) {
                                if (toolChild.getNodeName().equals("name")) {
                                    tool.setName(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("kind")) {
                                    tool.setKind(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("method")) {
                                    tool.setMethod(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("version")) {
                                    tool.setVersion(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("beginTime")) {
                                    tool.setBeginTime(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("endTime")) {
                                    tool.setEndTime(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("sourceFiles")) {
                                    ArrayList<FilePath> sourceFiles = new ArrayList<FilePath>();
                                    for (Node sourceFilesChild = toolChild.getFirstChild(); sourceFilesChild != null; sourceFilesChild = sourceFilesChild.getNextSibling()) {
                                        if (!sourceFilesChild.getNodeName().equals("filePath")) continue;
                                        FilePath filePath = new FilePath();
                                        filePath.setFilePath(sourceFilesChild.getTextContent());
                                        filePath.setType(XMLUtil.getAttribute(sourceFilesChild, "type"));
                                        filePath.setCreator(XMLUtil.getAttribute(sourceFilesChild, "creator"));
                                        sourceFiles.add(filePath);
                                    }
                                    tool.setSourceFiles(sourceFiles);
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("settings")) {
                                    ArrayList<String> settings = new ArrayList<String>();
                                    for (Node settingsChild = toolChild.getFirstChild(); settingsChild != null; settingsChild = settingsChild.getNextSibling()) {
                                        if (!settingsChild.getNodeName().equals("setting")) continue;
                                        settings.add(settingsChild.getTextContent());
                                    }
                                    tool.setSettings(settings);
                                    continue;
                                }
                                if (!toolChild.getNodeName().equals("results")) continue;
                                ArrayList<String> results = new ArrayList<String>();
                                for (Node resultsChild = toolChild.getFirstChild(); resultsChild != null; resultsChild = resultsChild.getNextSibling()) {
                                    if (!resultsChild.getNodeName().equals("result")) continue;
                                    results.add(resultsChild.getTextContent());
                                }
                                tool.setResults(results);
                            }
                            entry.setEntry(tool);
                            entry.setType("tool");
                        }
                        entries.add(entry);
                    }
                }
            }
            history.setEntries(entries);
            return rVal;
        }
        if (toObject instanceof Info) {
            Info info = (Info)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("fileInfo")) return rVal;
            for (Node fileInfoChild = root.getFirstChild(); fileInfoChild != null; fileInfoChild = fileInfoChild.getNextSibling()) {
                if (fileInfoChild.getNodeName().equals("mffVersion")) {
                    info.setMFFVersion(Integer.parseInt(fileInfoChild.getTextContent()));
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("recordTime")) {
                    info.setRecordTime(fileInfoChild.getTextContent());
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("ampSerialNumber")) {
                    info.setAmpSerialNumber(fileInfoChild.getTextContent());
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("ampFirmwareVersion")) {
                    info.setAmpFirmwareVersion(fileInfoChild.getTextContent());
                    continue;
                }
                if (!fileInfoChild.getNodeName().equals("movieDelta")) continue;
                info.setMovieDelta(Long.parseLong(fileInfoChild.getTextContent()));
            }
            return rVal;
        }
        if (toObject instanceof InfoN) {
            InfoN infoN = (InfoN)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("dataInfo")) return rVal;
            for (Node dataInfoChild = root.getFirstChild(); dataInfoChild != null; dataInfoChild = dataInfoChild.getNextSibling()) {
                if (!dataInfoChild.getNodeName().equals("generalInformation")) continue;
                for (Node generalInformationChild = dataInfoChild.getFirstChild(); generalInformationChild != null; generalInformationChild = generalInformationChild.getNextSibling()) {
                    if (generalInformationChild.getNodeName().equals("fileDataType")) {
                        for (Node fileDataTypeChild = generalInformationChild.getFirstChild(); fileDataTypeChild != null; fileDataTypeChild = fileDataTypeChild.getNextSibling()) {
                            if (fileDataTypeChild.getNodeName().equals("EEG")) {
                                InfoNFileTypeEEG infoNFileTypeEEG = new InfoNFileTypeEEG();
                                for (Node eegChild = fileDataTypeChild.getFirstChild(); eegChild != null; eegChild = eegChild.getNextSibling()) {
                                    if (eegChild.getNodeName().equals("sensorLayoutName")) {
                                        infoNFileTypeEEG.setSensorLayoutName(eegChild.getTextContent());
                                        continue;
                                    }
                                    if (!eegChild.getNodeName().equals("montageName")) continue;
                                    infoNFileTypeEEG.setMontageName(eegChild.getTextContent());
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypeEEG);
                                infoN.setInfoNFileType(0);
                                continue;
                            }
                            if (fileDataTypeChild.getNodeName().equals("Spectral")) {
                                InfoNFileTypeSpectral infoNFileTypeSpectral = new InfoNFileTypeSpectral();
                                for (Node spectralChild = fileDataTypeChild.getFirstChild(); spectralChild != null; spectralChild = spectralChild.getNextSibling()) {
                                    if (spectralChild.getNodeName().equals("sensorLayoutName")) {
                                        infoNFileTypeSpectral.setSensorLayoutName(spectralChild.getTextContent());
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("montageName")) {
                                        infoNFileTypeSpectral.setMontageName(spectralChild.getTextContent());
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("deltaF")) {
                                        infoNFileTypeSpectral.setDeltaF(Double.valueOf(spectralChild.getTextContent()));
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("path")) {
                                        infoNFileTypeSpectral.setPath(spectralChild.getTextContent());
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("beginTime")) {
                                        infoNFileTypeSpectral.setBeginTime(Long.valueOf(spectralChild.getTextContent()));
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("endTime")) {
                                        infoNFileTypeSpectral.setEndTime(Long.valueOf(spectralChild.getTextContent()));
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("minX")) {
                                        infoNFileTypeSpectral.setMinX(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("maxX")) {
                                        infoNFileTypeSpectral.setMaxX(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                        continue;
                                    }
                                    if (spectralChild.getNodeName().equals("minY")) {
                                        infoNFileTypeSpectral.setMinY(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                        continue;
                                    }
                                    if (!spectralChild.getNodeName().equals("maxY")) continue;
                                    infoNFileTypeSpectral.setMaxY(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypeSpectral);
                                infoN.setInfoNFileType(1);
                                continue;
                            }
                            if (fileDataTypeChild.getNodeName().equals("SourceData")) {
                                InfoNFileTypeSourceData infoNFileTypeSourceData = new InfoNFileTypeSourceData();
                                for (Node sourceDataChild = fileDataTypeChild.getFirstChild(); sourceDataChild != null; sourceDataChild = sourceDataChild.getNextSibling()) {
                                    if (sourceDataChild.getNodeName().equals("dipoleSetName")) {
                                        infoNFileTypeSourceData.setDipoleSetName(sourceDataChild.getTextContent());
                                        continue;
                                    }
                                    if (!sourceDataChild.getNodeName().equals("numberOfOrientation")) continue;
                                    infoNFileTypeSourceData.setNumberOfOrientation(Long.valueOf(sourceDataChild.getTextContent()));
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypeSourceData);
                                infoN.setInfoNFileType(2);
                                continue;
                            }
                            if (fileDataTypeChild.getNodeName().equals("PNSData")) {
                                InfoNFileTypePNSData infoNFileTypePNSData = new InfoNFileTypePNSData();
                                for (Node pnsDataChild = fileDataTypeChild.getFirstChild(); pnsDataChild != null; pnsDataChild = pnsDataChild.getNextSibling()) {
                                    if (!pnsDataChild.getNodeName().equals("pnsSetName")) continue;
                                    infoNFileTypePNSData.setPNSSetName(pnsDataChild.getTextContent());
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypePNSData);
                                infoN.setInfoNFileType(3);
                                continue;
                            }
                            if (fileDataTypeChild.getNodeName().equals("JTF")) {
                                InfoNFileTypeJTF infoNFileTypeJTF = new InfoNFileTypeJTF();
                                for (Node jtfChild = fileDataTypeChild.getFirstChild(); jtfChild != null; jtfChild = jtfChild.getNextSibling()) {
                                    if (jtfChild.getNodeName().equals("sensorLayoutName")) {
                                        infoNFileTypeJTF.setSensorLayoutName(jtfChild.getTextContent());
                                        continue;
                                    }
                                    if (jtfChild.getNodeName().equals("montageName")) {
                                        infoNFileTypeJTF.setMontageName(jtfChild.getTextContent());
                                        continue;
                                    }
                                    if (jtfChild.getNodeName().equals("path")) {
                                        infoNFileTypeJTF.setPath(jtfChild.getTextContent());
                                        continue;
                                    }
                                    if (!jtfChild.getNodeName().equals("samplingRate")) continue;
                                    infoNFileTypeJTF.setSamplingRate(Long.valueOf(jtfChild.getTextContent()));
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypeJTF);
                                infoN.setInfoNFileType(4);
                                continue;
                            }
                            if (!fileDataTypeChild.getNodeName().equals("TValues")) continue;
                            InfoNFileTypeTValues infoNFileTypeTValues = new InfoNFileTypeTValues();
                            for (Node tValuesChild = fileDataTypeChild.getFirstChild(); tValuesChild != null; tValuesChild = tValuesChild.getNextSibling()) {
                                if (tValuesChild.getNodeName().equals("sensorLayoutName")) {
                                    infoNFileTypeTValues.setSensorLayoutName(tValuesChild.getTextContent());
                                    continue;
                                }
                                if (!tValuesChild.getNodeName().equals("montageName")) continue;
                                infoNFileTypeTValues.setMontageName(tValuesChild.getTextContent());
                            }
                            infoN.setInfoNFileTypeInformation(infoNFileTypeTValues);
                            infoN.setInfoNFileType(5);
                        }
                        continue;
                    }
                    if (!generalInformationChild.getNodeName().equals("continuation")) continue;
                }
            }
            return rVal;
        }
        if (toObject instanceof Subject) {
            Subject subject = (Subject)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root = document.getDocumentElement();
            if (root != null) {
                root.normalize();
            }
            if (!root.getNodeName().equals("patient")) return rVal;
            for (Node patientChild = root.getFirstChild(); patientChild != null; patientChild = patientChild.getNextSibling()) {
                if (patientChild.getNodeName().equals("fields")) {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Node fieldsChild = patientChild.getFirstChild(); fieldsChild != null; fieldsChild = fieldsChild.getNextSibling()) {
                        if (!fieldsChild.getNodeName().equals("field")) continue;
                        Field field = new Field();
                        for (Node fieldChild = fieldsChild.getFirstChild(); fieldChild != null; fieldChild = fieldChild.getNextSibling()) {
                            if (fieldChild.getNodeName().equals("name")) {
                                field.setName(fieldChild.getTextContent());
                                continue;
                            }
                            if (fieldChild.getNodeName().equals("data")) {
                                field.setData(fieldChild.getTextContent());
                                continue;
                            }
                            if (fieldChild.getNodeName().equals("dataType")) {
                                field.setDataType(fieldChild.getTextContent());
                                continue;
                            }
                            if (!fieldChild.getNodeName().equals("choices")) continue;
                            field.setChoices(fieldChild.getTextContent());
                        }
                        fields.add(field);
                    }
                    subject.setFields(fields);
                    continue;
                }
                if (!patientChild.getNodeName().equals("mris")) continue;
                ArrayList<String> mris = new ArrayList<String>();
                for (Node mrisChild = patientChild.getFirstChild(); mrisChild != null; mrisChild = mrisChild.getNextSibling()) {
                    if (!mrisChild.getNodeName().equals("fileName")) continue;
                    mris.add(mrisChild.getTextContent());
                }
                subject.setMRIS(mris);
            }
            return rVal;
        } else {
            Element root;
            if (!(toObject instanceof PNSSet)) return rVal;
            PNSSet pnsSet = (PNSSet)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root = document.getDocumentElement()) == null) return rVal;
            root.normalize();
            if (!root.getNodeName().equals("PNSSet")) return rVal;
            for (Node pnsSetChild = root.getFirstChild(); pnsSetChild != null; pnsSetChild = pnsSetChild.getNextSibling()) {
                if (pnsSetChild.getNodeName().equals("name")) {
                    pnsSet.setName(pnsSetChild.getTextContent());
                    continue;
                }
                if (!pnsSetChild.getNodeName().equals("sensors")) continue;
                ArrayList<PNSSensor> sensors = new ArrayList<PNSSensor>();
                for (Node sensorsChild = pnsSetChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                    if (!sensorsChild.getNodeName().equals("sensor")) continue;
                    PNSSensor sensor = new PNSSensor();
                    for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                        if (sensorChild.getNodeName().equals("name")) {
                            sensor.setName(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("number")) {
                            sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("unit")) {
                            sensor.setUnit(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("psgType")) {
                            sensor.setPSGType(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("mapping")) {
                            sensor.setMapping(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("samplingRate")) {
                            sensor.setSamplingRate(Long.parseLong(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("highpass")) {
                            sensor.setHighpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("lowpass")) {
                            sensor.setLowpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("notch")) {
                            sensor.setNotch(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("groupNumber")) {
                            sensor.setGroupNumber(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (!sensorChild.getNodeName().equals("conversion")) continue;
                        sensor.setConversion(Integer.parseInt(sensorChild.getTextContent()));
                    }
                    sensors.add(sensor);
                }
                pnsSet.setPNSSensors(sensors);
            }
        }
        return rVal;
    }
}

